/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class SonargraphBuildClientVersionManager {
    private ISonargraphBuild.Version m_version;

    public SonargraphBuildClientVersionManager(String propertiesFile) {
        assert (propertiesFile != null && propertiesFile.length() > 0) : "Parameter 'propertiesFile' of method 'SonargraphBuildClientVersionManager' must not be empty";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream input = new FileInputStream(new File(propertiesFile));){
                Properties props = new Properties();
                props.load(input);
                this.m_version = ISonargraphBuild.Version.fromString(props.getProperty("sonargraph.version"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException("Cannot read version.properties from classPath: " + e.getMessage(), e);
        }
    }

    public SonargraphBuildClientVersionManager() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("version.properties");){
                Properties props = new Properties();
                props.load(input);
                this.m_version = ISonargraphBuild.Version.fromString(props.getProperty("sonargraph.version"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException("Cannot read version.properties from classPath: " + e.getMessage(), e);
        }
    }

    public ISonargraphBuild.Version getVersion() {
        return this.m_version;
    }
}

