/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BasePathForIncludes;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptionUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.StringReader;

public final class IncludeOption
extends DirectoryPath
implements ICompilerOption {
    public static final String PREFIX = "-I";
    public static final String LONG_PREFIX = "--include=";
    private final IBaseDirectory m_baseDir;
    private final String m_pathString;

    private IncludeOption(NamedElement parent, IBaseDirectory baseDir, String pathString) {
        super(parent);
        this.m_baseDir = baseDir;
        this.m_pathString = pathString;
    }

    public IBaseDirectory getBaseDirectory() {
        return this.m_baseDir;
    }

    @Override
    public String getValue() {
        TFile includeDir = this.getFile();
        return PREFIX + includeDir.getNormalizedAbsolutePath();
    }

    @Override
    public String getValueForPersistence() {
        if (this.m_pathString.contains("${")) {
            return PREFIX + this.m_pathString;
        }
        String path = this.getName();
        if (path.startsWith("../..")) {
            TFile includeDir = this.getFile();
            return PREFIX + includeDir.getNormalizedAbsolutePath();
        }
        return PREFIX + path;
    }

    /*
     * Unable to fully structure code
     */
    private static String expandEnvironmentVariables(String input) {
        sb = new StringBuilder();
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                reader = new StringReader(input);
                try {
                    while ((c = reader.read()) >= 0) {
                        block19: {
                            if (c != 36) break block19;
                            c = reader.read();
                            if (c != 123) ** GOTO lbl30
                            varNameBuffer = new StringBuilder();
                            while ((c = reader.read()) != -1 && c != 125) {
                                varNameBuffer.append((char)c);
                            }
                            varName = varNameBuffer.toString();
                            if (c == 125) {
                                val = System.getenv(varName);
                                if (val != null) {
                                    sb.append(val);
                                } else {
                                    sb.append("${").append(varName).append("}");
                                }
                            } else {
                                sb.append(varName);
                                break;
lbl30:
                                // 1 sources

                                sb.append('$');
                                if (c < 0) {
                                    break;
                                }
                            }
                        }
                        sb.append((char)c);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                } else if (var2_2 != var3_6) {
                    var2_2.addSuppressed(var3_6);
                }
                throw var2_2;
            }
        }
        catch (IOException var2_4) {
            // empty catch block
        }
        return sb.toString();
    }

    public static IncludeOption create(NamedElement parent, String optionLine) {
        assert (parent != null) : "Parameter 'parent' of method 'create' must not be null";
        assert (optionLine != null && optionLine.length() > 0) : "Parameter 'optionLine' of method 'create' must not be empty";
        ModuleSettings moduleSettings = (ModuleSettings)parent.getParent(ModuleSettings.class, new Class[0]);
        BasePathForIncludes baseDirForIncludes = moduleSettings == null ? null : (BasePathForIncludes)((Object)moduleSettings.getUniqueChild(BasePathForIncludes.class));
        String trimmedLine = optionLine.trim();
        assert (trimmedLine.startsWith(PREFIX)) : "Invalid include option '" + trimmedLine + "'";
        String path = IncludeOption.getPathFromOptionLine(trimmedLine);
        BasePathForIncludes baseDir = baseDirForIncludes == null ? (IBaseDirectory)parent.getParent(SoftwareSystem.class, new Class[0]) : baseDirForIncludes;
        IncludeOption includeOption = new IncludeOption(parent, baseDir, path);
        TFile dir = path.contains("${") ? new TFile(IncludeOption.expandEnvironmentVariables(path)) : new TFile(path);
        includeOption.init(dir, baseDir);
        return includeOption;
    }

    public static String getPathFromOptionLine(String trimmedLine) {
        return trimmedLine.substring(PREFIX.length());
    }

    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public String getFullyQualifiedNamePart() {
        return CompilerOptionUtility.createFullyQualifiedNamePart(this.getClass(), this.getValue());
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public Result validate() {
        Result result = new Result();
        TFile includeDir = this.getFile();
        if (includeDir.exists()) {
            return result;
        }
        result.addErrorMessage("Resulting include directory '" + includeDir.getNormalizedAbsolutePath() + "' does not exist");
        return result;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitIncludeOption(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitIncludeOption(IncludeOption var1);
    }
}

