/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectReference;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CPlusPlusVsProjectImportDto {
    private final TFile m_file;
    private final TFile m_directory;
    private String m_projectName;
    private String m_projectGuid;
    private final Map<SolutionFileInfo.ConfigurationAndPlatform, ProjectConfiguration> m_configurationMap = new HashMap<SolutionFileInfo.ConfigurationAndPlatform, ProjectConfiguration>();
    private final List<TFile> m_headerFiles = new ArrayList<TFile>();
    private final List<VisualStudioProjectReference> m_referencedProjects = new ArrayList<VisualStudioProjectReference>();
    private String m_toolsVersion = "4.0";
    private final TFile m_solutionDir;

    public CPlusPlusVsProjectImportDto(TFile file, TFile solutionDir) {
        assert (file != null) : "Parameter 'file' of method 'CPlusPlusVsProjectImportDto' must not be null";
        this.m_file = file.getNormalizedAbsoluteFile();
        this.m_directory = this.m_file.getParentFile();
        this.m_projectName = FileUtility.getFileNameWithoutExtension((TFile)this.m_file);
        this.m_solutionDir = solutionDir;
    }

    public TFile getSolutionDir() {
        return this.m_solutionDir;
    }

    public void addConfigurationAndPlatform(String configuration, String platform) {
        assert (configuration != null && configuration.length() > 0) : "Parameter 'configuration' of method 'addConfigurationAndPlatform' must not be empty";
        assert (platform != null && platform.length() > 0) : "Parameter 'platform' of method 'addConfigurationAndPlatform' must not be empty";
        SolutionFileInfo.ConfigurationAndPlatform config = new SolutionFileInfo.ConfigurationAndPlatform(configuration, platform);
        if (!this.m_configurationMap.containsKey(config)) {
            this.m_configurationMap.put(config, new ProjectConfiguration(configuration + "|" + platform));
        }
    }

    public void addHeaderFile(String value) {
        assert (value != null && value.length() > 0) : "Parameter 'value' of method 'addSourceFile' must not be empty";
        this.m_headerFiles.add(new TFile((File)this.m_directory, value).getNormalizedAbsoluteFile());
    }

    public List<TFile> getHeaderFiles() {
        return Collections.unmodifiableList(this.m_headerFiles);
    }

    public Map<SolutionFileInfo.ConfigurationAndPlatform, ProjectConfiguration> getConfigurations() {
        return Collections.unmodifiableMap(this.m_configurationMap);
    }

    public TFile getProjectFile() {
        return this.m_file;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    public void addVisualStudioProjectReference(String path, String projectKey) {
        TFile referencedProjectFile = null;
        referencedProjectFile = FileUtility.isRelativePath((String)path) ? new TFile((File)this.getProjectFile().getParentFile(), path).getNormalizedAbsoluteFile() : new TFile(path).getNormalizedAbsoluteFile();
        VisualStudioProjectReference reference = new VisualStudioProjectReference(referencedProjectFile, projectKey);
        if (!this.m_referencedProjects.contains(reference)) {
            this.m_referencedProjects.add(reference);
        }
    }

    public List<VisualStudioProjectReference> getProjectReferences() {
        return Collections.unmodifiableList(this.m_referencedProjects);
    }

    public void setProjectGUID(String GUID) {
        assert (GUID != null && GUID.length() > 0) : "Parameter 'GUID' of method 'setProjectGUID' must not be empty";
        this.m_projectGuid = GUID;
    }

    public String getProjectGuid() {
        return this.m_projectGuid;
    }

    public String getToolsVersion() {
        return this.m_toolsVersion;
    }

    public void setToolsVersion(String toolsVersion) {
        assert (toolsVersion != null && toolsVersion.length() > 0) : "Parameter 'toolsVersion' of method 'setToolsVersion' must not be empty";
        this.m_toolsVersion = toolsVersion;
    }

    public class ProjectConfiguration {
        private final String m_name;

        public ProjectConfiguration(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'Configuration' must not be empty";
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

