/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;

public enum BuiltInCompilerDefinition implements IStandardEnumeration
{
    GNU_CPP("GnuCpp", "Gnu C,C++ (64 bit)", false),
    CLANG("CLang", "CLang", false),
    MINGW32("MingW32", "MingW (32 bit, Windows)", true),
    CYGWIN_GCC("CygwinGnuCpp", "Cygwin gcc (Windows)", true),
    C816_GCC("C816GCC", "Raisonance Ride c816-gcc (Windows)", true),
    KEIL_ARM5("KeilARM5", "Keil ARM Compiler 5 (Windows)", true),
    KEIL_ARM6("KeilARM6", "Keil ARM Compiler 6 (Windows)", true),
    DIAB_5_9("DIAB-5.9", "Windriver DIAB 5.9 Compiler (Windows)", true);

    private final String m_name;
    private final String m_presentationName;
    private final boolean m_isWindows;

    private BuiltInCompilerDefinition(String fileName, String presentationName, boolean isWindows) {
        this.m_name = fileName;
        this.m_presentationName = presentationName;
        this.m_isWindows = isWindows;
    }

    public String getStandardName() {
        return this.m_name;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public boolean isWindows() {
        return this.m_isWindows;
    }

    public String toString() {
        return this.getStandardName();
    }

    public static BuiltInCompilerDefinition getDefaultDefinitionForPlatform() {
        if (Platform.isOperatingSystemUnixBased()) {
            if (Platform.isMac()) {
                return CLANG;
            }
            return GNU_CPP;
        }
        return null;
    }
}

