/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature;

import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureDecoder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignaturePrinter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.FunctionReturning;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CppParameterAndReturnTypeExtractor
extends CppSignaturePrinter {
    private final List<String> m_returnAndParameterTypes = new ArrayList<String>();

    private CppParameterAndReturnTypeExtractor() {
        super(true);
    }

    @Override
    public void visitFunctionReturning(FunctionReturning type) {
        type.getReturnType().accept(this);
        this.m_returnAndParameterTypes.add(this.getAndResetBuffer());
        for (Type t : type.getParameters()) {
            t.accept(this);
            this.m_returnAndParameterTypes.add(this.getAndResetBuffer());
        }
    }

    @Override
    protected void printFunction(FunctionReturning f, String core, boolean isConst, boolean isVolatile, boolean printReturnType) {
        f.accept(this);
    }

    public static List<String> getReturnAndParameterTypes(ProgrammingElement owner, String sig) {
        if (sig == null) {
            return List.of(null);
        }
        CppParameterAndReturnTypeExtractor extractor = new CppParameterAndReturnTypeExtractor();
        Type type = CppSignatureDecoder.decode(sig);
        type.accept(extractor);
        return Collections.unmodifiableList(extractor.m_returnAndParameterTypes);
    }
}

