/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MultipleHeaderFileIssue
extends CPlusPlusIssue {
    private final List<String> m_headerNames = new ArrayList<String>();

    public MultipleHeaderFileIssue() {
    }

    public MultipleHeaderFileIssue(NamedElement element) {
        super(element);
    }

    public void addHeaderName(String headerName, ProgrammingElement exampleDecl) {
        assert (exampleDecl != null) : "Parameter 'exampleDecl' of method 'addHeaderName' must not be null";
        this.m_headerNames.add(exampleDecl.getPresentationName(true) + " declared in " + headerName);
    }

    public IIssueId getId() {
        return CPlusPlusIssueId.SOURCE_HAS_MULTIPLE_HEADERS;
    }

    public int getLineNumber() {
        return 1;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder("Example declarations: ");
        builder.append(this.m_headerNames.get(0));
        int i = 1;
        while (i < this.m_headerNames.size()) {
            builder.append(", ");
            builder.append(this.m_headerNames.get(i));
            ++i;
        }
        return builder.toString();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        for (String headerName : this.m_headerNames) {
            writer.writeString(headerName);
        }
        writer.writeString(null);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        String name;
        super.retrieve(reader);
        while ((name = reader.readString()) != null) {
            this.m_headerNames.add(name);
        }
    }
}

