/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionSpec;
import java.io.IOException;

public class CppFunctionWithBody
extends CppFunctionSpec {
    private static final String MAX_NESTING = "maxNesting";
    private static final String NUMBER_OF_LOGICAL_OPERATIONS = "numberOfLogicalOperations";
    private static final String MODIFIED_CYCLOMATIC_COMPLEXITY = "modifiedCyclomaticComplexity";
    private static final String CYCLOMATIC_COMPLEXITY = "cyclomaticComplexity";
    private static final String NUMBER_OF_STATEMENTS = "numberOfStatements";
    private int m_numberOfStatements = 0;
    private int m_cyclomaticComplexity = 0;
    private int m_modifiedCyclomaticComplexity = 0;
    private short m_numberOfLogicalOperations = 0;
    private short m_maxNesting = 0;

    public CppFunctionWithBody() {
    }

    public CppFunctionWithBody(CppElement parent, CppElementType type, String name, int lineNo) {
        super(parent, type, name, lineNo);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeInt(NUMBER_OF_STATEMENTS, this.m_numberOfStatements);
        writer.writeInt(CYCLOMATIC_COMPLEXITY, this.m_cyclomaticComplexity);
        writer.writeInt(MODIFIED_CYCLOMATIC_COMPLEXITY, this.m_modifiedCyclomaticComplexity);
        writer.writeShort(NUMBER_OF_LOGICAL_OPERATIONS, this.m_numberOfLogicalOperations);
        writer.writeShort(MAX_NESTING, this.m_maxNesting);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_numberOfStatements = reader.readInt(NUMBER_OF_STATEMENTS);
        this.m_cyclomaticComplexity = reader.readInt(CYCLOMATIC_COMPLEXITY);
        this.m_modifiedCyclomaticComplexity = reader.readInt(MODIFIED_CYCLOMATIC_COMPLEXITY);
        this.m_numberOfLogicalOperations = reader.readShort(NUMBER_OF_LOGICAL_OPERATIONS);
        this.m_maxNesting = reader.readShort(MAX_NESTING);
    }

    public int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    public void addToNumberOfStatements(int numberOfStatements) {
        this.m_numberOfStatements += numberOfStatements;
    }

    public int getMaxNesting() {
        return this.m_maxNesting;
    }

    public void setMaxNesting(int maxNesting) {
        this.m_maxNesting = (short)maxNesting;
    }

    public int getCyclomaticComplexity() {
        return this.m_cyclomaticComplexity;
    }

    public void addToCyclomaticComplexity(int cyclomaticComplexity) {
        this.m_cyclomaticComplexity += cyclomaticComplexity;
    }

    public int getExtendedCyclomaticComplexity() {
        return this.m_cyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    public int getModifiedExtendedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    public int getModifiedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity;
    }

    public void addToModifiedCyclomaticComplexity(int modifiedCyclomaticComplexity) {
        this.m_modifiedCyclomaticComplexity += modifiedCyclomaticComplexity;
    }

    public void addToLogicalOperations(int additionalLogicalOperations) {
        this.m_numberOfLogicalOperations = (short)(this.m_numberOfLogicalOperations + additionalLogicalOperations);
    }

    public short getNumberOfLogicalOperations() {
        return this.m_numberOfLogicalOperations;
    }

    @Override
    public void accept(CppElement.Visitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)((Object)visitor)).visitCppFunctionWithBody(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCppFunctionWithBody(CppFunctionWithBody var1);
    }
}

