/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ExcludedDirectoryNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusSoftwareSystemSettingsProvider;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Collections;
import java.util.List;

final class CPlusPlusCMakeDeltaDetector
extends CPlusPlusDeltaDetector {
    private final List<DirectoryBean> m_roots;
    private final ICPlusPlusSoftwareSystemSettingsProvider m_sp;

    CPlusPlusCMakeDeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, boolean firstModificationOnly, List<DirectoryBean> roots, ICPlusPlusSoftwareSystemSettingsProvider sp) {
        super(workerContext, languageProvider, filter, module, Collections.emptyList(), firstModificationOnly);
        assert (roots != null && !roots.isEmpty());
        assert (sp != null) : "Parameter 'sp' of method 'CPlusPlusCMakeDeltaDetector' must not be null";
        this.m_roots = roots;
        this.m_sp = sp;
    }

    protected void prepareScan(OperationResult result) {
    }

    @Override
    protected void scanRootDirectory(RootDirectoryPath root) {
        if (this.scanningIsDone()) {
            return;
        }
        TFile rootDir = root.getFile();
        DirectoryBean rootBean = null;
        for (DirectoryBean dirBean : this.m_roots) {
            rootBean = dirBean.findDirectory(dirFile -> FileUtility.areEqual((TFile)dirFile, (TFile)rootDir));
            if (rootBean != null) break;
        }
        if (rootBean != null) {
            RootDirectorySettings settingsNode = (RootDirectorySettings)root.getFirstChild(RootDirectorySettings.class);
            if (settingsNode != null) {
                for (ExcludedDirectoryNode dirNode : settingsNode.getChildren(ExcludedDirectoryNode.class)) {
                    TFile excludedDirFile = new TFile((File)rootDir, dirNode.getShortName()).getNormalizedAbsoluteFile();
                    DirectoryBean excludedDir = rootBean.findDirectory(dirFile -> FileUtility.areEqual((TFile)dirFile, (TFile)excludedDirFile));
                    if (excludedDir == null) continue;
                    excludedDir.setExcluded(true);
                }
            }
            for (SourceFileBean sourceBean : rootBean.getAllSourceFiles()) {
                CPlusPlusFileType fileType = sourceBean.getFileName().endsWith(".c") ? CPlusPlusFileType.C_SOURCE : CPlusPlusFileType.CPP_SOURCE;
                this.consume(rootDir, sourceBean.getFile(), fileType);
                this.m_sp.registerOptions(sourceBean.getFile().getNormalizedAbsolutePath(), sourceBean.getOptions());
            }
        }
    }
}

