/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathValidator;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.SearchPath;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GeneratedInstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromBundle;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromFile;
import de.schlichtherle.truezip.file.TFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CppSearchPathValidator
extends SearchPathValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CppSearchPathValidator.class);
    private final ICPlusPlusInstallationExtension m_provider;

    public CppSearchPathValidator(ICPlusPlusInstallationExtension provider) {
        assert (provider != null) : "Parameter 'provider' of method 'CppSearchPathValidator' must not be null";
        this.m_provider = provider;
    }

    public void validate(SearchPath searchPath, TFile newPath, OperationResult result) {
        InstCompilerDefinition activeDefinition = this.m_provider.getActiveCompilerDefinition();
        if (activeDefinition == null) {
            return;
        }
        if (activeDefinition instanceof InstCompilerDefinitionFromBundle || activeDefinition instanceof GeneratedInstCompilerDefinition) {
            LOGGER.debug("Active compiler definition from bundle is not affected by changes to the search path");
            return;
        }
        InstCompilerDefinitionFromFile activeDefFromFile = (InstCompilerDefinitionFromFile)activeDefinition;
        TFile file = activeDefFromFile.getFile();
        SearchPath newSearchPath = new SearchPath(new TFile[]{newPath});
        for (TFile dir : searchPath.getDirectories()) {
            newSearchPath.add(dir);
        }
        TFile newDefFile = newSearchPath.locateFile(file.getName());
        if (newDefFile == null) {
            result.addWarning((OperationResult.IMessageCause)CppCauses.ACTIVE_COMPILER_DEFINITION_NON_EXISTENT, "Specified active definition '" + activeDefFromFile.getName() + "' is no longer found in search path." + StringUtility.LINE_SEPARATOR + "Using default compiler definition '" + this.m_provider.getDefaultDefinitionIdForPlatform() + "' instead.", new Object[0]);
            return;
        }
        if (FileUtility.areEqual((TFile)file, (TFile)newDefFile)) {
            return;
        }
        result.addWarning((OperationResult.IMessageCause)CppCauses.ACTIVE_COMPILER_DEFINITION_CHANGED, "Specified active definition '" + String.valueOf((Object)activeDefFromFile) + "' loaded from file '" + file.getNormalizedAbsolutePath() + "' will be replaced by definition loaded from file '" + newDefFile.getNormalizedAbsolutePath() + "'", new Object[0]);
    }
}

