/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SendFeedbackCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusLanguageProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.List;

public final class CPlusPlusReportParsingProblemCommand
extends SendFeedbackCommand {
    public CPlusPlusReportParsingProblemCommand(ISoftwareSystemProvider provider, SendFeedbackCommand.IInteraction interaction, ProxySettings proxySettings) {
        super(provider, interaction, proxySettings);
    }

    public static TFile getDiagnosticsDir(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getLastDiagnosticFiles' must not be null";
        ILanguageProvider lp = provider.getLanguageProvider((Language)CPlusPlusLanguage.INSTANCE);
        assert (lp instanceof CPlusPlusLanguageProvider) : "Unexpected class: " + lp.getClass().getName();
        CPlusPlusLanguageProvider cppLp = (CPlusPlusLanguageProvider)lp;
        return cppLp.getDiagnosticsDir();
    }

    public static OperationResultWithOutcome<List<TFile>> getDiagnosticsFiles(TFile diagnosticsDir) {
        assert (diagnosticsDir != null) : "Parameter 'diagnosticsDir' of method 'getDiagnosticsFiles' must not be null";
        assert (diagnosticsDir.exists() && diagnosticsDir.isDirectory()) : "Parameter 'diagnosticsDir' of method 'getDiagnosticsFiles' must be an existing directory";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Collect all C,C++ diagnostic files");
        try {
            result.setOutcome((Object)FileUtility.getAllFilesRecursively((TFile)diagnosticsDir));
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed to collect diagnostics files", new Object[]{ex});
        }
        return result;
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.REPORT_PARSING_PROBLEM;
    }
}

