/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.ui;

import com.hello2morrow.sonargraph.build.ui.BuildWaitForCommandCompletion;
import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.FixedSizeFiFoQueue;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildUserInterfaceAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildUserInterfaceAdapter.class);
    private static BuildUserInterfaceAdapter s_instance;
    private static final int EXCEPTION_LOG_SIZE = 10;
    private FixedSizeFiFoQueue<String> m_exceptionLog = new FixedSizeFiFoQueue(10);

    private BuildUserInterfaceAdapter() {
        EventManager.getInstance().attach((EventHandler)new EventHandler<ExceptionEvent>(ExceptionEvent.class, (Object)this){

            public void handleEvent(ExceptionEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                LOGGER.error("Exception caught", (Throwable)event.getException());
                BuildUserInterfaceAdapter.this.m_exceptionLog.add((Object)ExceptionUtility.collectFirstAndLast((Throwable)event.getException()));
            }
        });
    }

    public Optional<String> getExceptionMessagesForLastCommandExecution() {
        assert (BuildUserInterfaceAdapter.hasInstance()) : "Instance not created";
        List exceptions = BuildUserInterfaceAdapter.s_instance.m_exceptionLog.getElements();
        if (exceptions.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(StringUtility.concat((Collection)exceptions, (String)(StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR)));
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static void createInstance() {
        assert (!BuildUserInterfaceAdapter.hasInstance()) : "Instance already created";
        s_instance = new BuildUserInterfaceAdapter();
    }

    public static BuildUserInterfaceAdapter getInstance() {
        assert (BuildUserInterfaceAdapter.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public void delete() {
        assert (BuildUserInterfaceAdapter.hasInstance()) : "Instance not created";
        EventManager.getInstance().detach(ExceptionEvent.class, (Object)this);
        s_instance = null;
    }

    public void process(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'process' must not be null";
        if (result.isFailure() || result.containsError()) {
            LOGGER.error(result.toString());
        } else if (result.containsWarning()) {
            LOGGER.warn(result.toString());
        } else if (result.containsInfo()) {
            LOGGER.info(result.toString());
        }
    }

    public void runWaitingForCompletion(Command command, IWorkerContext workerContext) {
        assert (command != null) : "Parameter 'command' of method 'runWaitingForCompletion' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'runWaitingForCompletion' must not be null";
        this.m_exceptionLog = new FixedSizeFiFoQueue(10);
        BuildWaitForCommandCompletion waitForCommandCompletion = new BuildWaitForCommandCompletion(command, workerContext);
        waitForCommandCompletion.run();
    }
}

