/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.build.api.ProgressInfo;
import com.hello2morrow.sonargraph.build.service.impl.SonargraphBuildReporter;
import com.hello2morrow.sonargraph.build.ui.BuildUserInterfaceAdapter;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphBuildSystemRefresh {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphBuildSystemRefresh.class);

    static RefreshSoftwareSystemCommand createRefreshCommand(final ISoftwareSystemProvider systemProvider, final ProgressInfo progressInfo, final OperationResult refreshResult) {
        RefreshSoftwareSystemCommand refresh = new RefreshSoftwareSystemCommand(systemProvider, new RefreshCommand.IRefreshInteraction(){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                data.setLocation(systemProvider.getSoftwareSystem().getDirectoryFile());
                return true;
            }

            public void collectRefreshData(RefreshCommand.RefreshData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.addOptions(new ISoftwareSystemProvider.IRefreshOption[]{ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL});
            }

            public void processOpenResult(OperationResult result) {
                BuildUserInterfaceAdapter.getInstance().process(result);
                refreshResult.addMessagesFromAndSetOutcome(result);
            }

            public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean hasUndoHistory) {
                SonargraphBuildReporter.reportProgress(progressInfo, "Sonargraph workspace has been updated due to changed external resources.");
                return true;
            }

            public boolean closeSoftwareSystem() {
                return false;
            }

            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                LOGGER.debug("Files needing save: " + data.getToBeSaved().stream().map(f -> f.getIdentifyingPath()).collect(Collectors.joining(", ")));
                return true;
            }

            public boolean processSaveResult(OperationResult result) {
                if (result.isFailure()) {
                    SonargraphBuildReporter.reportError(progressInfo, "Saving updated files failed: " + String.valueOf(result));
                }
                return true;
            }

            public INavigationState getNavigationState() {
                return null;
            }

            public void processPrepareRefreshResult(PrepareRefreshResult result) {
                BuildUserInterfaceAdapter.getInstance().process((OperationResult)result);
                refreshResult.addMessagesFromAndSetOutcome((OperationResult)result);
            }

            public RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse confirmPreRefreshSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification modification) {
                return RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CONTINUE;
            }

            public boolean confirmPreRefreshActions(PrepareRefreshResult result) {
                return true;
            }

            public boolean answerPreRefreshQuestion(PrepareRefreshResult.Question question) {
                if (!$assertionsDisabled && question == null) {
                    throw new AssertionError((Object)"Parameter 'question' of method 'answerPreRefreshQuestion' must not be null");
                }
                return true;
            }

            public void processRefreshResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processRefreshResult' must not be null");
                }
                BuildUserInterfaceAdapter.getInstance().process(result);
                refreshResult.addMessagesFromAndSetOutcome(result);
            }

            public void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
                if (!$assertionsDisabled && saveResult == null) {
                    throw new AssertionError((Object)"Parameter 'saveResult' of method 'processSaveResultDueToExternalFileChangesOnOpen' must not be null");
                }
                BuildUserInterfaceAdapter.getInstance().process(saveResult);
            }
        });
        return refresh;
    }
}

