/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.architecture.model;

import com.hello2morrow.sonargraph.integration.architecture.model.ArchitectureElement;
import com.hello2morrow.sonargraph.integration.architecture.model.Connector;
import com.hello2morrow.sonargraph.integration.architecture.model.Interface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class Artifact
extends ArchitectureElement {
    private final Artifact parent;
    private final EnumSet<Stereotype> stereotypes = EnumSet.noneOf(Stereotype.class);
    private final List<Artifact> children = new ArrayList<Artifact>();
    private final List<Interface> interfaces = new ArrayList<Interface>();
    private final List<Connector> connectors = new ArrayList<Connector>();

    public Artifact(Artifact parent, String fqn) {
        super(fqn);
        this.parent = parent;
    }

    public void addStereoType(Stereotype st) {
        assert (st != null);
        this.stereotypes.add(st);
    }

    public void addChild(Artifact child) {
        assert (child != null);
        assert (child.getParent() == this);
        this.children.add(child);
    }

    public void addInterface(Interface iface) {
        assert (iface != null);
        this.interfaces.add(iface);
    }

    public void addConnector(Connector conn) {
        assert (conn != null);
        this.connectors.add(conn);
    }

    public Artifact getParent() {
        return this.parent;
    }

    public Set<Stereotype> getStereotypes() {
        return Collections.unmodifiableSet(this.stereotypes);
    }

    public List<Artifact> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<Interface> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public List<Connector> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public static enum Stereotype {
        PUBLIC,
        HIDDEN,
        LOCAL,
        EXPOSED,
        OPTIONAL,
        DEPRECATED,
        UNRESTRICTED,
        RELAXED,
        STRICT;

    }
}

