/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.report;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;

public final class MetricRow {
    private final IMetricId m_id;
    private final IMetricLevel m_level;
    private final IMetricValue m_value;
    private final NamedElement m_associatedElement;

    public MetricRow(IMetricId id, IMetricLevel level, IMetricValue value) {
        assert (id != null) : "Parameter 'id' of method 'MetricRow' must not be null";
        assert (level != null) : "Parameter 'level' of method 'MetricRow' must not be null";
        assert (value != null) : "Parameter 'value' of method 'MetricRow' must not be null";
        assert (value.getValue() != null) : "No metric value for '" + String.valueOf(id) + ":" + String.valueOf(level) + "'";
        this.m_id = id;
        this.m_level = level;
        this.m_value = value;
        this.m_associatedElement = value.getAssociatedElement();
    }

    public NamedElement getAssociatedElement() {
        return this.m_associatedElement;
    }

    public String getMetricLevel() {
        return this.m_level.getPresentationName();
    }

    public String getMetricName() {
        return this.m_id.getPresentationName();
    }

    public String getElementName() {
        return this.m_value.getAssociatedElement().getPresentationName(false);
    }

    public Number getMetricValue() {
        return this.m_value.getValue();
    }

    IMetricValue getMetricValueObject() {
        return this.m_value;
    }

    public IMetricId getId() {
        return this.m_id;
    }

    public boolean isFloat() {
        return this.m_id.isFloat();
    }

    public String toString() {
        return "MetricRow [m_id=" + String.valueOf(this.m_id) + ", m_level=" + String.valueOf(this.m_level) + ", m_value=" + String.valueOf(this.m_value) + ", m_associatedElement=" + String.valueOf(this.m_associatedElement) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_associatedElement == null ? 0 : this.m_associatedElement.hashCode());
        result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        result = 31 * result + (this.m_level == null ? 0 : this.m_level.hashCode());
        result = 31 * result + (this.m_value == null ? 0 : this.m_value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricRow other = (MetricRow)obj;
        if (this.m_associatedElement == null ? other.m_associatedElement != null : !this.m_associatedElement.equals(other.m_associatedElement)) {
            return false;
        }
        if (this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id)) {
            return false;
        }
        if (this.m_level == null ? other.m_level != null : !this.m_level.equals(other.m_level)) {
            return false;
        }
        return !(this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value));
    }
}

