/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.model.refactoring.ElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Arrays;
import java.util.List;

public abstract class RecursiveElementRefactoringDescriptor
extends ElementRefactoringDescriptor {
    protected RecursiveElementRefactoringDescriptor() {
    }

    public abstract ElementType getType();

    public abstract String getImageResourcePart();

    public abstract String getSeparator();

    public final List<String> split(String candidate) {
        assert (candidate != null && candidate.length() > 0) : "Parameter 'candidate' of method 'split' must not be empty";
        return Arrays.asList(candidate.split("\\" + this.getSeparator()));
    }

    @Override
    public final String getPresentationKind() {
        return this.getType().getPresentationName();
    }

    @Override
    public final boolean isValidNameForRename(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isValidNameForRename' must not be empty";
        String separator = this.getSeparator();
        assert (separator != null && !separator.isEmpty()) : "'separator' of method 'isValidNameForRename' must not be empty";
        if (name.startsWith(separator) || name.endsWith(separator)) {
            return false;
        }
        List<String> splitName = this.split(name);
        if (splitName.isEmpty()) {
            return false;
        }
        block4: for (String nextName : splitName) {
            switch (this.getType()) {
                case DIRECTORY: {
                    if (FileUtility.isValidName((String)nextName)) continue block4;
                    return false;
                }
                case NAMESPACE: {
                    if (nextName.isEmpty()) {
                        return false;
                    }
                    if (!Character.isJavaIdentifierStart(nextName.charAt(0))) {
                        return false;
                    }
                    int i = 1;
                    while (i < nextName.length()) {
                        char c = nextName.charAt(i);
                        if (!Character.isJavaIdentifierPart(c)) {
                            return false;
                        }
                        ++i;
                    }
                    continue block4;
                }
                default: {
                    assert (false) : "Unhandled type: " + String.valueOf((Object)this.getType());
                    continue block4;
                }
            }
        }
        return true;
    }

    public static enum ElementType implements IStandardEnumeration
    {
        DIRECTORY,
        NAMESPACE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

