/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.ILanguageScope;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.LogicalStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ILogicalProgrammingElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalRoot;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class LogicalNamespaceRoot
extends LogicalRoot
implements ILanguageScope,
ILogicalProgrammingElementContainer,
IArchitectureFilterNamePrefixProvider,
IDomainRoot {
    private final ArrayList<LogicalNamespace> m_logicalNamespaces = new ArrayList();
    private LogicalNamespace m_globalNamespace;

    public LogicalNamespaceRoot(NamedElement parent) {
        super(parent);
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public final boolean ignoreInModelRepresentation() {
        return false;
    }

    public abstract LogicalNamespaceScope getScope();

    public final void addLogicalNamespace(LogicalNamespace logicalNamespace) {
        assert (logicalNamespace != null) : "Parameter 'logicalNamespace' of method 'addLogicalNamespace' must not be null";
        this.m_logicalNamespaces.add(logicalNamespace);
    }

    public final List<LogicalNamespace> getNonPartLogicalNamespaces() {
        ArrayList<LogicalNamespace> nonParts = new ArrayList<LogicalNamespace>();
        for (LogicalNamespace next : this.m_logicalNamespaces) {
            if (next.isPart()) continue;
            nonParts.add(next);
        }
        return nonParts;
    }

    public final LogicalNamespace getGlobalLogicalNamespace() {
        return this.m_globalNamespace;
    }

    @Override
    public final IStructureItem getStructureItem() {
        return LogicalStructureItem.LOGICAL_NAMESPACE_ROOT;
    }

    @Override
    public void finishModification() {
        this.m_logicalNamespaces.trimToSize();
        final String namespaceSeparator = this.getLanguage().getNamespaceSeparator();
        Collections.sort(this.m_logicalNamespaces, new Comparator<LogicalNamespace>(){

            @Override
            public int compare(LogicalNamespace n1, LogicalNamespace n2) {
                if (!$assertionsDisabled && n1 == null) {
                    throw new AssertionError((Object)"Parameter 'n1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && n2 == null) {
                    throw new AssertionError((Object)"Parameter 'n2' of method 'compare' must not be null");
                }
                int depthN1 = StringUtility.countString((String)namespaceSeparator, (String)n1.getName());
                int depthN2 = StringUtility.countString((String)namespaceSeparator, (String)n2.getName());
                return depthN2 - depthN1;
            }
        });
        LogicalNamespace globalNamespace = null;
        Iterator<LogicalNamespace> iter = this.m_logicalNamespaces.iterator();
        while (iter.hasNext()) {
            LogicalNamespace next = iter.next();
            if (!next.hasChildren()) {
                iter.remove();
                next.remove();
                next.disconnect();
                continue;
            }
            next.finishModification();
            if (!next.isGlobal()) continue;
            assert (globalNamespace == null) : "'globalNamespace' of method 'finishModification' must be null";
            globalNamespace = next;
        }
        this.m_globalNamespace = globalNamespace;
        super.finishModification();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitLogicalNamespaceRoot(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitLogicalNamespaceRoot(LogicalNamespaceRoot var1);
    }
}

