/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.model.element.Element;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public final class ConditionFilter<T extends Element> {
    private Set<Predicate<T>> m_filterConditions;
    private Set<Predicate<T>> m_ignoreConditions;
    private FilterMode m_filterMode = FilterMode.ANY_MATCH;
    private boolean m_hasFiltered = false;

    public ConditionFilter() {
    }

    public ConditionFilter(ConditionFilter<T> filterToCopy) {
        assert (filterToCopy != null) : "Parameter 'filterToCopy' of method 'ResolutionFilter' must not be null";
        this.m_filterConditions = filterToCopy.m_filterConditions == null ? null : new HashSet<Predicate<T>>(filterToCopy.m_filterConditions);
        this.m_ignoreConditions = filterToCopy.m_ignoreConditions == null ? null : new HashSet<Predicate<T>>(filterToCopy.m_ignoreConditions);
        this.m_hasFiltered = filterToCopy.m_hasFiltered;
    }

    public boolean test(T element) {
        return this.accept(element, true);
    }

    public boolean accept(T element) {
        return this.accept(element, false);
    }

    private boolean accept(T element, boolean testOnly) {
        assert (element != null) : "Parameter 'element' of method 'accept' must not be null";
        if (this.ignore(element)) {
            return false;
        }
        boolean accepted = this.matches(element);
        if (!testOnly) {
            this.m_hasFiltered = this.m_hasFiltered || !accepted && !((Element)element).isExcluded();
        }
        return accepted;
    }

    private boolean matches(T element) {
        assert (element != null) : "Parameter 'element' of method 'matches' must not be null";
        if (this.m_filterConditions == null) {
            return true;
        }
        for (Predicate<T> filterCondition : this.m_filterConditions) {
            if (filterCondition.test(element)) {
                if (this.m_filterMode != FilterMode.ANY_MATCH) continue;
                return true;
            }
            if (this.m_filterMode != FilterMode.ALL_MATCH) continue;
            return false;
        }
        switch (this.m_filterMode) {
            case ANY_MATCH: {
                return false;
            }
            case ALL_MATCH: {
                return true;
            }
        }
        assert (false) : "Unexpected 'm_filterMode': " + String.valueOf((Object)this.m_filterMode);
        return false;
    }

    private boolean ignore(T element) {
        assert (element != null) : "Parameter 'element' of method 'ignore' must not be null";
        if (this.m_ignoreConditions == null) {
            return false;
        }
        for (Predicate<T> filterCondition : this.m_ignoreConditions) {
            if (!filterCondition.test(element)) continue;
            return true;
        }
        return false;
    }

    public void add(Predicate<T> filterCondition) {
        assert (filterCondition != null) : "Parameter 'filterCondition' of method 'add' must not be null";
        if (this.m_filterConditions == null) {
            this.m_filterConditions = new HashSet<Predicate<T>>();
        }
        this.m_filterConditions.add(filterCondition);
    }

    public void addIgnore(Predicate<T> ignoreCondition) {
        assert (ignoreCondition != null) : "Parameter 'filterCondition' of method 'addIgnore' must not be null";
        if (this.m_ignoreConditions == null) {
            this.m_ignoreConditions = new HashSet<Predicate<T>>();
        }
        this.m_ignoreConditions.add(ignoreCondition);
    }

    public void remove(Predicate<T> filterCondition) {
        assert (filterCondition != null) : "Parameter 'filterCondition' of method 'remove' must not be null";
        assert (this.m_filterConditions != null) : " 'm_filterConditions' of method 'remove' must not be null";
        this.m_filterConditions.remove(filterCondition);
    }

    public void resetHasFiltered() {
        this.m_hasFiltered = false;
    }

    public boolean hasFiltered() {
        return this.m_hasFiltered;
    }

    public void clear(boolean clearIgnoreConditions) {
        if (clearIgnoreConditions) {
            this.m_ignoreConditions = null;
        }
        this.m_filterConditions = null;
        this.resetHasFiltered();
    }

    public void setFilterMode(FilterMode filterMode) {
        assert (filterMode != null) : "Parameter 'filterMode' of method 'setFilterMode' must not be null";
        this.m_filterMode = filterMode;
    }

    public static enum FilterMode {
        ANY_MATCH,
        ALL_MATCH;

    }
}

