/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import de.schlichtherle.truezip.file.TFile;

public final class SoftwareSystemBaseDirectory
extends DirectoryPath
implements IBaseDirectory {
    public static IPathValidator getValidator() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null || newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (!newInput.exists()) {
                    result.addError("Does not exist");
                } else if (!newInput.isDirectory()) {
                    result.addError("Is not a directory");
                } else if (!newInput.canWrite()) {
                    result.addError("No write permission");
                }
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    public SoftwareSystemBaseDirectory(NamedElement parent) {
        super(parent);
    }

    public SoftwareSystemBaseDirectory(NamedElement parent, TFile file) {
        super(parent, file);
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return "BaseDirectory";
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    protected void lastChildRemoved() {
    }

    @Override
    public boolean removeOnLastChildRemoval() {
        return false;
    }

    @Override
    public String getImageResourceName() {
        return DirectoryPath.class.getSimpleName();
    }

    @Override
    public IBaseDirectory getBaseDirectory() {
        return null;
    }

    @Override
    public TFile getDirectoryFile() {
        return this.getFile();
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return true;
    }
}

