/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public final class DescriptorCache {
    private final Map<Element, String> m_elementToDescriptor = new THashMap();

    public void addDescriptor(Element element, String descriptor) {
        assert (element != null) : "Parameter 'element' of method 'addDescriptor' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'addDescriptor' must not be empty";
        this.m_elementToDescriptor.put(element, descriptor.intern());
    }

    public String getDescriptor(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getDescriptor' must not be null";
        return this.m_elementToDescriptor.get(element);
    }

    public String toString() {
        return this.m_elementToDescriptor.size() + " element descriptor(s)";
    }
}

