/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.javapg.runtime.messaging.Position;
import java.util.ArrayList;
import java.util.List;

public class Identifier {
    private final Position m_position;
    private final List<String> m_idents = new ArrayList<String>();

    public Identifier(Position pos) {
        this.m_position = pos;
    }

    public Identifier(Position pos, String p1) {
        this.m_position = pos;
        this.addIdent(p1);
    }

    public Identifier(Position pos, String p1, String p2) {
        this.m_position = pos;
        this.addIdent(p1);
        if (p2 != null) {
            this.addIdent(p2);
        }
    }

    public Identifier(Position pos, String p1, String p2, String p3) {
        this.m_position = pos;
        this.addIdent(p1);
        if (p2 != null) {
            this.addIdent(p2);
            if (p3 != null) {
                this.addIdent(p3);
            }
        }
    }

    public void addIdent(String ident) {
        assert (ident != null && ident.length() > 0) : "Parameter 'ident' of method 'addIdent' must not be empty";
        this.m_idents.add(ident);
    }

    public int numberOfParts() {
        return this.m_idents.size();
    }

    public String getNamePart(int index) {
        return this.m_idents.get(index);
    }

    public Identifier shiftLeft() {
        assert (this.m_idents.size() >= 1) : "Cannot shift empty identifier";
        int offset = this.getIdent().length();
        if (this.m_idents.size() > 1) {
            ++offset;
        }
        Identifier result = new Identifier(this.m_position == null ? null : this.m_position.offsetBy(offset));
        int i = 1;
        while (i < this.m_idents.size()) {
            result.addIdent(this.m_idents.get(i));
            ++i;
        }
        return result;
    }

    public String getIdent() {
        return this.m_idents.size() > 0 ? this.m_idents.get(0) : null;
    }

    public String getQualifier() {
        return this.m_idents.size() > 1 ? this.m_idents.get(1) : null;
    }

    public String getDetail() {
        return this.m_idents.size() > 2 ? this.m_idents.get(2) : null;
    }

    public Position getPosition() {
        return this.m_position;
    }

    public String getQualifiedName() {
        StringBuilder sb = new StringBuilder();
        if (this.m_idents.size() > 0) {
            sb.append(this.getIdent());
            int i = 1;
            while (i < this.m_idents.size()) {
                sb.append('.').append(this.m_idents.get(i));
                ++i;
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_idents == null ? 0 : this.m_idents.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return !(this.m_idents == null ? other.m_idents != null : !this.m_idents.equals(other.m_idents));
    }
}

