/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.annotation;

import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AnnotationValueList
extends AnnotationValue
implements ISnapshotWriter.IWriteStorableContext {
    private final ArrayList<AnnotationValue> m_list = new ArrayList();

    @Override
    public void finishModification() {
        this.m_list.trimToSize();
        super.finishModification();
    }

    public void addValue(AnnotationValue value) {
        assert (value != null) : "Parameter 'value' of method 'addValue' must not be null";
        this.m_list.add(value);
    }

    @Override
    public List<AnnotationValue> asList() {
        return Collections.unmodifiableList(this.m_list);
    }

    public boolean isEmpty() {
        return this.m_list.isEmpty();
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        int size = reader.readInt();
        while (size > 0) {
            this.m_list.add(reader.read(AnnotationValue.class, new SnapshotArgument[0]));
            --size;
        }
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (writer != null) : "Parameter 'writer' of method 'store' must not be null";
        writer.writeInt(this.m_list.size());
        for (AnnotationValue value : this.m_list) {
            writer.write(value, this);
        }
    }

    @Override
    public void addDiagnosticInfo(StringBuilder builder) {
        assert (builder != null) : "Parameter 'builder' of method 'addDiagnosticInfo' must not be null";
    }

    @Override
    public void visitChildren(AnnotationValue.AnnotationVisitor v) {
        this.m_list.forEach(value -> value.accept(v));
    }

    @Override
    public void accept(AnnotationValue.AnnotationVisitor v) {
        if (v instanceof IVisitor) {
            ((IVisitor)((Object)v)).visitAnnotationValueList(this);
        } else {
            super.accept(v);
        }
    }

    public String toString() {
        return "{ " + Joiner.join(this.m_list) + " }";
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("Contains ").append(this.m_list.size()).append(" annotations:");
        for (AnnotationValue next : this.m_list) {
            builder.append("\n");
            builder.append(next.getDebugInfo());
        }
        return builder.toString();
    }

    public static interface IVisitor {
        public void visitAnnotationValueList(AnnotationValueList var1);
    }
}

