/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.base.IIssueParticipationProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorOrHeightValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ConfigurableIssueCollector;
import com.hello2morrow.sonargraph.core.controller.system.treemap.IssueInfoProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.NoIssueInfoProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.IssueCollectorValueSource;
import java.util.List;

final class IssueCollectorIntValueAccessor
extends ColorOrHeightValueAccessor {
    private final NoIssueInfoProvider m_noIssuesColorProvider = new NoIssueInfoProvider();
    private final ConfigurableIssueCollector m_issueCollector;

    IssueCollectorIntValueAccessor(IssueCollectorValueSource valueSource, IIssueParticipationProvider participationProvider) {
        assert (valueSource != null) : "Parameter 'valueSource' of method 'IssueCollectorValueAccessor' must not be null";
        assert (participationProvider != null) : "Parameter 'participationProvider' of method 'IssueCollectorValueAccessor' must not be null";
        this.m_issueCollector = new ConfigurableIssueCollector(valueSource, participationProvider);
    }

    @Override
    ILeafInfoProvider getInfoProvider(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getColorInfoProvider' must not be null";
        element.accept(this.m_issueCollector);
        List<Issue> nextIssues = this.m_issueCollector.consumeIssues();
        int numberOfIssues = nextIssues.size();
        this.getValueRange().process(0, numberOfIssues);
        return numberOfIssues == 0 ? this.m_noIssuesColorProvider : new IssueInfoProvider(nextIssues);
    }
}

