/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.AssignedToplevelNodesCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewLogger;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StateHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureHandler;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ResetInfo;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import java.util.List;

public final class ModificationHandler
implements IExplorationViewRepresentationHandler {
    private ModificationHandler() {
    }

    public static Pair<ExplorationViewFocus, ArchitecturalViewState> startModification(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'startModification' must not be null";
        assert (!representation.inInitialCreation()) : "In initial creation";
        ExplorationViewLogger.logStartModification(representation);
        ResetInfo resetInfo = representation.startModification();
        RepresentationHandler.aboutToChangeStructure(true, representation);
        ArchitecturalViewState state = StateHandler.createState(representation);
        RepresentationHandler.removeAggregatedDependencies(true, representation);
        ExplorationViewFocus focus = representation.getFocus();
        if (!focus.isEmpty()) {
            FocusHandler.resetFocus(true, representation);
        }
        RepresentationHandler.collapseAll(false, representation);
        List<ArtifactNode> topLevelArtifacts = representation.getChildren(ArtifactNode.class);
        if (!topLevelArtifacts.isEmpty()) {
            List<NonRecursiveRootNode> assignedTopLevelNodes = AssignedToplevelNodesCollector.collect(topLevelArtifacts);
            assignedTopLevelNodes.forEach(a -> StructureHandler.integrate(a, representation, null, true, representation));
            topLevelArtifacts.forEach(n -> n.remove());
        }
        RepresentationHandler.reset(resetInfo.getNodeToOriginalLocation(), representation);
        return new Pair((Object)(focus.isEmpty() ? null : focus), (Object)(state.isEmpty() ? null : state));
    }

    public static void finishModification(IWorkerContext workerContext, ExplorationViewRepresentation representation, ExplorationViewFocus focus, ArchitecturalViewState state, StateHandler.IApplyStateListener applyStateListener, ArchitecturalViewNodeInfo nodeInfo) {
        List<ArchitecturalViewNode> leafNodes;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishModification' must not be null";
        assert (representation != null) : "Parameter 'state' of method 'finishModification' must not be null";
        ExplorationViewLogger.logFinishModification(representation);
        if (nodeInfo == null) {
            workerContext.working("Finish element stucture", true);
            leafNodes = RepresentationHandler.finishElementStructure(representation).getLeafNodes();
        } else {
            leafNodes = nodeInfo.getLeafNodes();
        }
        workerContext.working("Finish artifact model", true);
        ArtifactHandler.finishArtifactModelModification(true, representation);
        workerContext.working("Sort nodes", true);
        RepresentationHandler.sortNodes(workerContext, leafNodes, representation);
        if (state != null) {
            workerContext.working("Apply nodes state", true);
            StateHandler.applyNodesState(state, applyStateListener, representation);
        }
        if (focus != null) {
            workerContext.working("Apply focus", true);
            FocusHandler.applyFocus(focus, representation);
        }
        workerContext.working("Create aggregated dependencies", true);
        RepresentationHandler.createAggregatedDependencies(true, representation);
        if (state != null) {
            workerContext.working("Apply dependencies state", true);
            StateHandler.applyDependenciesState(state, representation);
        }
        representation.modificationFinished();
        RepresentationHandler.structureChanged(true, true, representation);
    }
}

