/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletion;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletionArtifact;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletionArtifactCollector;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureAutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoCompletionProposalsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoCompletionProposalsCollector.class);

    private AutoCompletionProposalsCollector() {
    }

    private static String calculatePath(AutoCompletionArtifact from, AutoCompletionArtifact to) {
        assert (from != null) : "Parameter 'from' of method 'calculatePath' must not be null";
        assert (to != null) : "Parameter 'to' of method 'calculatePath' must not be null";
        if (from == to || from.isChildOf(to)) {
            return null;
        }
        List<AutoCompletionArtifact> fromChain = from.getArtifactChain();
        List<AutoCompletionArtifact> toChain = to.getArtifactChain();
        int indexOfFirstDifferentArtifact = 0;
        int i = 0;
        while (i < fromChain.size()) {
            if (toChain.size() > i) {
                AutoCompletionArtifact nextTo;
                AutoCompletionArtifact nextFrom = fromChain.get(i);
                if (nextFrom != (nextTo = toChain.get(i))) break;
                ++indexOfFirstDifferentArtifact;
            }
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        int i2 = indexOfFirstDifferentArtifact;
        while (i2 < toChain.size()) {
            AutoCompletionArtifact nextTo = toChain.get(i2);
            if (isFirst) {
                isFirst = false;
            } else if (!nextTo.isExposed()) {
                return null;
            }
            builder.append(nextTo.getName()).append('.');
            ++i2;
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private static AutoCompletionArtifact resolve(List<String> parts, List<AutoCompletionArtifact> toplevelArtifacts) {
        assert (parts != null && !parts.isEmpty()) : "Parameter 'parts' of method 'resolve' must not be empty";
        AutoCompletionArtifact current = null;
        for (AutoCompletionArtifact nextToplevel : toplevelArtifacts) {
            if (!nextToplevel.getName().equals(parts.get(0))) continue;
            current = nextToplevel;
            break;
        }
        if (current != null) {
            int i = 1;
            while (i < parts.size()) {
                String nextPart = parts.get(i);
                AutoCompletionArtifact nextResolved = null;
                for (AutoCompletionArtifact nextNested : current.getArtifacts()) {
                    if (!nextNested.getName().equals(nextPart)) continue;
                    nextResolved = nextNested;
                    break;
                }
                current = nextResolved;
                if (current == null) break;
                ++i;
            }
        }
        return current;
    }

    private static void addArtifactsAndInterfacesRecursively(Collection<AutoCompletionArtifact> artifacts, AutoCompletionArtifact artifactContainingLine, Set<ArchitectureAutoCompletionProposal> proposals, int replacementOffset, int replacementLength) {
        assert (artifacts != null) : "Parameter 'artifacts' of method 'addArtifactsAndInterfacesRecursively' must not be null";
        assert (artifactContainingLine != null) : "Parameter 'artifactContainingLine' of method 'addArtifactsAndInterfacesRecursively' must not be null";
        assert (proposals != null) : "Parameter 'proposals' of method 'addArtifactsAndInterfacesRecursively' must not be null";
        for (AutoCompletionArtifact next : artifacts) {
            if (next == artifactContainingLine) continue;
            String path = AutoCompletionProposalsCollector.calculatePath(artifactContainingLine, next);
            if (path != null) {
                proposals.add(new ArchitectureAutoCompletionProposal(path, replacementOffset, replacementLength, ArchitectureAutoCompletionProposal.Type.ARTIFACT));
                for (String nextInterface : next.getInterfaces()) {
                    proposals.add(new ArchitectureAutoCompletionProposal(path + "." + nextInterface, replacementOffset, replacementLength, ArchitectureAutoCompletionProposal.Type.INTERFACE));
                }
            }
            AutoCompletionProposalsCollector.addArtifactsAndInterfacesRecursively(next.getArtifacts(), artifactContainingLine, proposals, replacementOffset, replacementLength);
        }
    }

    private static List<ArchitectureAutoCompletionProposal> collectArtifactProposals(ArtifactBasedProposals artifactBasedProposals, String text, int line, String leadingCharacters, int replacementOffset, int replacementLength, String identifyingPath, Architecture architecture) {
        block28: {
            assert (artifactBasedProposals != null) : "Parameter 'artifactBasedProposals' of method 'collectArtifactProposals' must not be null";
            assert (text != null && text.length() > 0) : "Parameter 'text' of method 'collectArtifactProposals' must not be empty";
            assert (line >= 1) : "At least line number 1 expected: " + line;
            assert (leadingCharacters != null) : "Parameter 'leadingCharacters' of method 'collectArtifactProposals' must not be null";
            assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'collectArtifactProposals' must not be empty";
            assert (architecture != null) : "Parameter 'architecture' of method 'collectArtifactProposals' must not be null";
            try {
                ArrayList<AutoCompletionArtifact> toplevelArtifacts = new ArrayList<AutoCompletionArtifact>();
                AutoCompletionArtifact artifactContainingLine = AutoCompletionArtifactCollector.collectArtifacts(text, line, toplevelArtifacts, identifyingPath, architecture);
                if (toplevelArtifacts.isEmpty() || artifactContainingLine == null) break block28;
                LOGGER.debug("Top level artifacs: " + toplevelArtifacts.size() + ", artifact containing line '" + line + "': " + String.valueOf(artifactContainingLine));
                THashSet proposals = new THashSet();
                switch (artifactBasedProposals) {
                    case ARTIFACTS_AND_INTERFACES: {
                        if (leadingCharacters.isEmpty()) {
                            AutoCompletionProposalsCollector.addArtifactsAndInterfacesRecursively(toplevelArtifacts, artifactContainingLine, (Set<ArchitectureAutoCompletionProposal>)proposals, replacementOffset, replacementLength);
                            break;
                        }
                        if (leadingCharacters.indexOf(46) == -1) {
                            for (AutoCompletionArtifact next : toplevelArtifacts) {
                                if (next == artifactContainingLine || !next.getName().startsWith(leadingCharacters)) continue;
                                AutoCompletionProposalsCollector.addArtifactsAndInterfacesRecursively(Collections.singletonList(next), artifactContainingLine, (Set<ArchitectureAutoCompletionProposal>)proposals, replacementOffset, replacementLength);
                            }
                        } else {
                            List<String> parts = Arrays.asList(leadingCharacters.split("\\."));
                            assert (parts.size() >= 1) : "At least 1 part expected";
                            AutoCompletionArtifact resolved = parts.size() == 1 ? AutoCompletionProposalsCollector.resolve(parts, toplevelArtifacts) : AutoCompletionProposalsCollector.resolve(parts.subList(0, parts.size() - 1), toplevelArtifacts);
                            if (resolved == null) break;
                            if (leadingCharacters.endsWith(".")) {
                                for (AutoCompletionArtifact autoCompletionArtifact : resolved.getArtifacts()) {
                                    AutoCompletionProposalsCollector.addArtifactsAndInterfacesRecursively(Collections.singletonList(autoCompletionArtifact), artifactContainingLine, (Set<ArchitectureAutoCompletionProposal>)proposals, replacementOffset, replacementLength);
                                }
                                for (String string : resolved.getInterfaces()) {
                                    proposals.add(new ArchitectureAutoCompletionProposal(resolved.getFullName() + "." + string, replacementOffset, replacementLength, ArchitectureAutoCompletionProposal.Type.INTERFACE));
                                }
                            } else {
                                String string = parts.get(parts.size() - 1);
                                for (AutoCompletionArtifact autoCompletionArtifact : resolved.getArtifacts()) {
                                    if (autoCompletionArtifact == artifactContainingLine || !autoCompletionArtifact.getName().startsWith(string)) continue;
                                    AutoCompletionProposalsCollector.addArtifactsAndInterfacesRecursively(Collections.singletonList(autoCompletionArtifact), artifactContainingLine, (Set<ArchitectureAutoCompletionProposal>)proposals, replacementOffset, replacementLength);
                                }
                                for (String string2 : resolved.getInterfaces()) {
                                    if (!string2.startsWith(string)) continue;
                                    proposals.add(new ArchitectureAutoCompletionProposal(resolved.getFullName() + "." + string2, replacementOffset, replacementLength, ArchitectureAutoCompletionProposal.Type.INTERFACE));
                                }
                            }
                        }
                        break;
                    }
                    case CONNECTORS: {
                        if (leadingCharacters.isEmpty()) {
                            for (String next : artifactContainingLine.getConnectors()) {
                                proposals.add(new ArchitectureAutoCompletionProposal(next, replacementOffset, replacementLength, ArchitectureAutoCompletionProposal.Type.CONNECTOR));
                            }
                        } else {
                            for (String next : artifactContainingLine.getConnectors()) {
                                if (!next.startsWith(leadingCharacters)) continue;
                                proposals.add(new ArchitectureAutoCompletionProposal(next, replacementOffset, replacementLength, ArchitectureAutoCompletionProposal.Type.CONNECTOR));
                            }
                        }
                        break;
                    }
                }
                if (!proposals.isEmpty()) {
                    return proposals.stream().sorted((p1, p2) -> p1.getProposal().compareTo(p2.getProposal())).collect(Collectors.toList());
                }
            }
            catch (Throwable t) {
                LOGGER.error("Exception during artifact based auto completion proposal collection", t);
            }
        }
        return Collections.emptyList();
    }

    public static List<AutoCompletionProposal> getAutoCompletionProposals(String text, int offset, int line, String identifyingPath, Architecture architecture) {
        assert (text != null) : "Parameter 'text' of method 'getAutoCompletionProposals' must not be null";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAutoCompletionProposals' must not be empty";
        assert (architecture != null) : "Parameter 'architecture' of method 'getAutoCompletionProposals' must not be null";
        if (!text.isEmpty() && offset >= 0 && line >= 1) {
            StringBuilder builder = new StringBuilder();
            int index = offset - 1;
            while (index >= 0) {
                char nextChar = text.charAt(index);
                Character nextSeparator = AutoCompletion.isSeparator(nextChar);
                if (nextSeparator != null && nextSeparator.charValue() != '.') break;
                builder.insert(0, nextChar);
                --index;
            }
            String leadingCharacters = builder.toString();
            builder.setLength(0);
            while (index >= 0) {
                char nextChar = text.charAt(index);
                Character nextSeparator = AutoCompletion.isSeparator(nextChar);
                if (nextSeparator != null) {
                    if (nextSeparator.charValue() == '{' || nextSeparator.charValue() == '}') {
                        builder.setLength(0);
                        break;
                    }
                    if (builder.length() > 0) {
                        if (AutoCompletion.getKeywords().contains(builder.toString())) break;
                        builder.setLength(0);
                    }
                } else {
                    builder.insert(0, nextChar);
                }
                --index;
            }
            String leadingKeyword = builder.toString();
            builder.setLength(0);
            ArtifactBasedProposals artifactBasedProposals = null;
            if (!leadingKeyword.isEmpty()) {
                if (leadingKeyword.equals("to")) {
                    artifactBasedProposals = ArtifactBasedProposals.ARTIFACTS_AND_INTERFACES;
                } else if (leadingKeyword.equals("connect")) {
                    artifactBasedProposals = ArtifactBasedProposals.CONNECTORS;
                }
            }
            if (!leadingCharacters.isEmpty() || artifactBasedProposals != null) {
                int i = offset;
                while (i < text.length()) {
                    char nextChar = text.charAt(i);
                    Character nextSeparator = AutoCompletion.isSeparator(nextChar);
                    if (nextSeparator != null && nextSeparator.charValue() != '.') break;
                    builder.append(nextChar);
                    ++i;
                }
                String trailingCharacters = builder.toString();
                builder.setLength(0);
                int replacementOffset = offset - leadingCharacters.length();
                int replacementLength = leadingCharacters.length() + trailingCharacters.length();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Collect proposals\n Leading keyword: '" + leadingKeyword + "'\n Leading characters: '" + leadingCharacters + "'\n Trailing characters: '" + trailingCharacters + "'\n Collect: " + (String)(artifactBasedProposals == null ? "keywords only" : "keywords and " + artifactBasedProposals.name().toLowerCase()));
                }
                ArrayList<AutoCompletionProposal> proposals = new ArrayList<AutoCompletionProposal>();
                if (!leadingCharacters.isEmpty()) {
                    for (String string : AutoCompletion.getKeywords()) {
                        if (!string.startsWith(leadingCharacters)) continue;
                        char add = AutoCompletion.getKeywordsWithFollowingDot().contains(string) ? (char)'.' : ' ';
                        int endOffset = offset + trailingCharacters.length();
                        if (endOffset >= text.length() || text.charAt(endOffset) != add) {
                            proposals.add(new ArchitectureAutoCompletionProposal(string + add, replacementOffset, replacementLength, ArchitectureAutoCompletionProposal.Type.KEYWORD));
                            continue;
                        }
                        proposals.add(new ArchitectureAutoCompletionProposal(string, replacementOffset, replacementLength, 1, ArchitectureAutoCompletionProposal.Type.KEYWORD));
                    }
                }
                if (artifactBasedProposals != null) {
                    proposals.addAll(AutoCompletionProposalsCollector.collectArtifactProposals(artifactBasedProposals, text, line, leadingCharacters, replacementOffset, replacementLength, identifyingPath, architecture));
                }
                if (LOGGER.isTraceEnabled()) {
                    for (AutoCompletionProposal autoCompletionProposal : proposals) {
                        LOGGER.trace("Proposal: " + String.valueOf(autoCompletionProposal));
                    }
                }
                LOGGER.debug("Collect proposals - done");
                return proposals;
            }
        }
        return Collections.emptyList();
    }

    static enum ArtifactBasedProposals {
        ARTIFACTS_AND_INTERFACES,
        CONNECTORS;

    }
}

