/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueInfo;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class AnalyzerResultReader
extends ObjectReader {
    private final IAnalyzerController m_controller;
    private final IMetricsProvider m_metricProvider;
    private final List<Issue> m_issues = new ArrayList<Issue>();

    protected AnalyzerResultReader(AnalyzerResult result, IAnalyzerController controller) {
        super(controller.getClassLoader());
        assert (result != null) : "Parameter 'result' of method 'AnalyzerResultReader' must not be null";
        assert (controller != null) : "Parameter 'controller' of method 'AnalyzerResultReader' must not be null";
        this.m_controller = controller;
        this.pushParent(result);
        this.defineVariable("analyzerId", result.getParent(Analyzer.class, new Class[0]).getId());
        this.m_metricProvider = controller.getInstallation().getExtension(IMetricsProvider.class);
    }

    public List<? extends IPersistable> retrieve(TFile file) throws IOException, RestoreException {
        assert (file != null) : "Parameter 'file' of method 'retrieve' must not be null";
        List result = super.retrieve(file);
        for (Issue issue : this.m_issues) {
            ((ElementWithIssues)issue.getAffectedElement()).addIssue(issue);
        }
        return result;
    }

    protected ObjectReader.IFactory createFactory(Class<? extends IPersistable> cls) throws RestoreException {
        assert (cls != null) : "Parameter 'cls' of method 'createFactory' must not be null";
        if (NamedElement.class.isAssignableFrom(cls)) {
            return new NamedElementFactory(cls);
        }
        return super.createFactory(cls);
    }

    protected void objectRead(IPersistable obj) {
        assert (obj != null) : "Parameter 'obj' of method 'objectRead' must not be null";
        if (obj instanceof Issue) {
            Issue issue = (Issue)obj;
            assert (issue.getId() != null);
            this.m_issues.add(issue);
        } else if (obj instanceof ArchitectureViolationIssueInfo) {
            ArchitectureViolationIssueInfo issueInfo = (ArchitectureViolationIssueInfo)obj;
            this.m_controller.getInstallation().addProviderIds(issueInfo.getProviderIds());
        }
        super.objectRead(obj);
    }

    public <T extends IPersistable> void readObjectReference(String attributeName, Class<T> expectedClass, Consumer<T> consumer) throws RestoreException {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        assert (expectedClass != null) : "Parameter 'expectedClass' of method 'readObjectReference' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'readObjectReference' must not be null";
        String descriptor = this.readString(attributeName);
        if (descriptor == null) {
            super.readObjectReference(attributeName, expectedClass, consumer);
        } else {
            Element obj = this.m_controller.getResolver().resolve(descriptor);
            if (obj == null) {
                throw new RestoreException("Cannot resolve descriptor: " + descriptor);
            }
            consumer.accept(obj);
        }
    }

    public <T> void readOther(String attributeName, Class<T> expectedClass, Consumer<T> consumer) throws RestoreException {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'readBoolean' must not be empty";
        assert (expectedClass != null) : "Parameter 'expectedClass' of method 'readObjectReference' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'readObjectReference' must not be null";
        if (expectedClass.equals(Language.class)) {
            String langName = this.readString(attributeName);
            consumer.accept(this.m_controller.getLanguageByName(langName));
        } else if (IMetricDescriptor.class.isAssignableFrom(expectedClass)) {
            String[] descriptor = this.readString(attributeName).split(":");
            IMetricDescriptor md = this.m_metricProvider.findMetricByIdAndLevel(descriptor[0], descriptor[1]);
            if (md == null) {
                throw new RestoreException("Cannot resolve metric descriptor " + descriptor[0] + ":" + descriptor[1]);
            }
            consumer.accept((Language)((Object)md));
        } else if (NamedElement.class.isAssignableFrom(expectedClass)) {
            this.readObjectReference(attributeName, NamedElement.class, ne -> consumer.accept((Language)ne));
        } else {
            super.readOther(attributeName, expectedClass, consumer);
        }
    }

    protected <T extends IPersistable> T resolveUnexpectedItem(Object descriptor, Class<T> expectedClass) throws RestoreException {
        if (descriptor instanceof String) {
            Element obj = this.m_controller.getResolver().resolve((String)descriptor);
            if (obj == null) {
                throw new RestoreException("Cannot resolve descriptor: " + String.valueOf(descriptor));
            }
            return (T)obj;
        }
        return (T)super.resolveUnexpectedItem(descriptor, expectedClass);
    }

    private static class NamedElementFactory
    implements ObjectReader.IFactory {
        private final Constructor<? extends NamedElement> m_constructor;

        private NamedElementFactory(Class<? extends IPersistable> cls) throws RestoreException {
            assert (cls != null) : "Parameter 'cls' of method 'NamedElementfactory' must not be null";
            try {
                this.m_constructor = cls.getConstructor(NamedElement.class);
            }
            catch (Throwable e) {
                throw new RestoreException("Cannot find matching constructor for class: " + cls.getName(), e);
            }
        }

        public IPersistable createObject(IObjectReader reader) throws RestoreException {
            NamedElement product;
            assert (reader != null) : "Parameter 'reader' of method 'createObject' must not be null";
            NamedElement parent = (NamedElement)reader.getCurrentParent(NamedElement.class);
            try {
                product = this.m_constructor.newInstance(parent);
            }
            catch (Throwable e) {
                throw new RestoreException("Cannot create new instance for class: " + this.m_constructor.getDeclaringClass().getName(), e);
            }
            parent.addChild(product);
            return product;
        }
    }
}

