/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.WorkspaceProfileExtension;
import com.hello2morrow.sonargraph.core.controller.system.base.AbstractUndoRedoProvider;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfiles;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public final class WorkspaceProfileUndoRedoProvider
extends AbstractUndoRedoProvider {
    private final SoftwareSystem m_softwareSystem;

    public WorkspaceProfileUndoRedoProvider(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'WorkspaceProfileUndoRedoProvider' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(WorkspaceProfile.class);
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeModifiableFileToStream' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'writeModifiableFileToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        this.m_softwareSystem.getExtension(WorkspaceProfileExtension.class).getPersistence().save(outputStream, (WorkspaceProfile)file, result);
    }

    @Override
    public OperationResultWithOutcome<? extends IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) throws IOException {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restore workspace profile '" + dto.getModifiableFilePath() + "'");
        Files files = this.m_softwareSystem.getUniqueExistingChild(Files.class);
        Optional<IModifiableFile> match = files.findById(dto.getModifiableFileId());
        assert (match.isPresent()) : "WorkspaceProfile '" + dto.getModifiableFilePath() + "' must exist!";
        WorkspaceProfile toBeRestored = (WorkspaceProfile)match.get();
        WorkspaceProfileExtension profileExtension = this.m_softwareSystem.getExtension(WorkspaceProfileExtension.class);
        result.addMessagesFrom(profileExtension.getPersistence().load(inputStream, toBeRestored));
        if (result.isFailure()) {
            return result;
        }
        if (!toBeRestored.getIdentifyingPath().equals(dto.getCurrentStateFileEntry().getIdentifyingPath())) {
            TFile newPath = new TFile((File)toBeRestored.getParent(WorkspaceProfiles.class, new Class[0]).getFile(), dto.getCurrentStateFileEntry().getIdentifyingPath()).getNormalizedAbsoluteFile();
            try {
                toBeRestored.getFile().mv((File)newPath);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            toBeRestored.setPath(newPath);
        }
        result.setOutcome((Object)toBeRestored);
        return result;
    }
}

