/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IArchitecturalFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.AbstractUndoRedoProvider;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class ArchitecturalViewUndoRedoProvider
extends AbstractUndoRedoProvider {
    private final IArchitecturalFileProvider m_fileProvider;

    public ArchitecturalViewUndoRedoProvider(IArchitecturalFileProvider fileProvider) {
        assert (fileProvider != null) : "Parameter 'fileProvider' of method 'ArchitecturalViewUndoRedoProvider' must not be null";
        this.m_fileProvider = fileProvider;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(ArchitecturalViewFile.class);
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be empty";
        return AnalyzerExecutionInfo.none();
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeModifiableFileToStream' must not be null";
        assert (file instanceof ArchitecturalViewFile) : "Unexpected class: " + file.getClass().getName();
        assert (outputStream != null) : "Parameter 'outputStream' of method 'writeModifiableFileToStream' must not be null";
        this.m_fileProvider.save((ArchitecturalViewFile)file, outputStream, result);
    }

    @Override
    public OperationResultWithOutcome<? extends IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) throws IOException {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        String identifyingPath = dto.getCurrentStateFileEntry().getIdentifyingPath();
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restoring architectural view file '" + identifyingPath + "' from stream");
        ArchitecturalViewFile file = this.m_fileProvider.findByIdentifyingPath(identifyingPath);
        assert (file != null) : "'file' of method 'restoreModifiableFileFromStream' must not be null";
        this.m_fileProvider.restoreFile(file, inputStream, (OperationResult)result);
        result.setOutcome((Object)file);
        return result;
    }
}

