/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.script;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class CreateScriptDirectoryCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public static ITextValidator getDirectoryNameValidator(ISoftwareSystemProvider provider, DirectoryPath parentDirectoryPath) {
        assert (provider != null) : "Parameter 'provider' of method 'getDirectoryNameValidator' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        return provider.getSoftwareSystem().getExtension(IGroovyExtension.class).getDirectoryNameValidator(parentDirectoryPath);
    }

    public CreateScriptDirectoryCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.CREATE_GROOVY_DIRECTORY;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        GroovyDirectoryData data = new GroovyDirectoryData();
        if (((IInteraction)this.getInteraction()).collect(data)) {
            DirectoryPath parentDirectory = data.getParentDirectory();
            String directoryName = data.getDirectoryName();
            OperationResult result = this.getController().getSoftwareSystem().getExtension(IGroovyExtension.class).createDirectory(workerContext, parentDirectory, directoryName);
            ((IInteraction)this.getInteraction()).processCreateGroovyDirectoryResult(result);
        }
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public static final class GroovyDirectoryData
    implements ICommandInteractionData {
        private DirectoryPath m_parentDirectory;
        private String m_directoryName;

        public DirectoryPath getParentDirectory() {
            return this.m_parentDirectory;
        }

        public void setParentDirectory(DirectoryPath parentDirectory) {
            assert (parentDirectory != null) : "Parameter 'parentDirectory' of method 'setParentDirectory' must not be null";
            this.m_parentDirectory = parentDirectory;
        }

        public String getDirectoryName() {
            return this.m_directoryName;
        }

        public void setDirectoryName(String directoryName) {
            assert (directoryName != null && directoryName.length() > 0) : "Parameter 'directoryName' of method 'setDirectoryName' must not be empty";
            this.m_directoryName = directoryName;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(GroovyDirectoryData var1);

        public void processCreateGroovyDirectoryResult(OperationResult var1);
    }
}

