/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.qualitygate;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityGateExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public class EditQualityGateConditionCommand
extends SoftwareSystemBasedCommand<IEditConditionInteraction> {
    public EditQualityGateConditionCommand(ISoftwareSystemProvider provider, IEditConditionInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_QUALITY_GATE_CONDITION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        if (((IEditConditionInteraction)this.getInteraction()).collect(data)) {
            IQualityGateExtension extension = this.getController().getSoftwareSystem().getExtension(IQualityGateExtension.class);
            OperationResultWithOutcome<IQualityGateCondition> result = extension.editCondition(workerContext, data.getQualityGate(), data.getConditionToEdit(), data.getConditionInfo());
            ((IEditConditionInteraction)this.getInteraction()).processResult(result);
        }
    }

    public static interface IEditConditionInteraction
    extends ICommandInteraction {
        public boolean collect(InteractionData var1);

        public void processResult(OperationResultWithOutcome<IQualityGateCondition> var1);
    }

    public static final class InteractionData
    implements ICommandInteractionData {
        private QualityGate m_qualityGate;
        private IQualityGateCondition m_conditionToEdit;
        private IQualityGateConditionInfo m_conditionInfo;

        public QualityGate getQualityGate() {
            return this.m_qualityGate;
        }

        public void setQualityGate(QualityGate qualityGate) {
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'setQualityGate' must not be null";
            this.m_qualityGate = qualityGate;
        }

        public void setConditionToEdit(IQualityGateCondition conditionToEdit) {
            assert (conditionToEdit != null) : "Parameter 'conditionToEdit' of method 'setConditionToEdit' must not be null";
            this.m_conditionToEdit = conditionToEdit;
        }

        public IQualityGateCondition getConditionToEdit() {
            return this.m_conditionToEdit;
        }

        public IQualityGateConditionInfo getConditionInfo() {
            return this.m_conditionInfo;
        }

        public void setConditionInfo(IQualityGateConditionInfo conditionInfo) {
            assert (conditionInfo != null) : "Parameter 'conditionInfo' of method 'setConditionInfo' must not be null";
            this.m_conditionInfo = conditionInfo;
        }
    }
}

