/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecture;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitectureExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;

public final class RemoveArchitectureFileFromArchitectureCheckCommand
extends SoftwareSystemBasedCommand<IRemoveInteraction> {
    public RemoveArchitectureFileFromArchitectureCheckCommand(ISoftwareSystemProvider provider, IRemoveInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.REMOVE_ARCHITECTURE_FILE_FROM_ARCHITECTURE_CHECK;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        RemoveData data = new RemoveData();
        if (((IRemoveInteraction)this.getInteraction()).collect(data)) {
            OperationResult result = this.getController().getSoftwareSystem().getExtension(IArchitectureExtension.class).removeFromArchitectureCheck(workerContext, data.getElements());
            ((IRemoveInteraction)this.getInteraction()).processRemoveResult(result);
        }
    }

    public static interface IRemoveInteraction
    extends ICommandInteraction {
        public boolean collect(RemoveData var1);

        public void processRemoveResult(OperationResult var1);
    }

    public static final class RemoveData
    implements ICommandInteractionData {
        private final List<Element> m_elements = new ArrayList<Element>();

        public void addElements(List<Element> elements) {
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'addElements' must not be empty";
            this.m_elements.addAll(elements);
        }

        List<Element> getElements() {
            return this.m_elements;
        }
    }
}

