/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingProperties;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class CreateFindingCommand
extends ArchitecturalViewCommand<ICreateFindingInteraction> {
    public CreateFindingCommand(ISoftwareSystemProvider provider, ICreateFindingInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_ARCHITECTURAL_VIEW_FINDING;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        CreateFindingData data = new CreateFindingData();
        if (!((ICreateFindingInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.createFinding(workerContext, data.getProperties());
        ((ICreateFindingInteraction)this.getInteraction()).processCreateFindingResult(result);
    }

    public static final class CreateFindingData
    implements IArchitecturalViewCommandInteractionData {
        private ArchitecturalViewFindingProperties m_properties;

        CreateFindingData() {
        }

        public void setProperties(ArchitecturalViewFindingProperties properties) {
            assert (properties != null) : "Parameter 'properties' of method 'setProperties' must not be null";
            this.m_properties = properties;
        }

        ArchitecturalViewFindingProperties getProperties() {
            assert (this.m_properties != null) : "'m_properties' of method 'getProperties' must not be null";
            return this.m_properties;
        }
    }

    public static interface ICreateFindingInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(CreateFindingData var1);

        public void processCreateFindingResult(OperationResult var1);
    }
}

