/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;

public final class RefreshSoftwareSystemFilesCommand
extends RefreshCommand {
    public RefreshSoftwareSystemFilesCommand(ISoftwareSystemProvider provider, RefreshCommand.IRefreshInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.REFRESH_SOFTWARE_SYSTEM_FILES;
    }

    @Override
    protected boolean refreshOnSoftwareSystemReload() {
        return false;
    }

    public static abstract class RefreshSoftwareSystemFilesInteraction
    implements RefreshCommand.IRefreshInteraction {
        private final SoftwareSystem m_softwareSystem;

        public RefreshSoftwareSystemFilesInteraction(SoftwareSystem softwareSystem) {
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'RefreshSoftwareSystemFilesInteraction' must not be null";
            this.m_softwareSystem = softwareSystem;
        }

        @Override
        public final boolean closeSoftwareSystem() {
            return true;
        }

        @Override
        public final void collectRefreshData(RefreshCommand.RefreshData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
        }

        @Override
        public final boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            return true;
        }

        @Override
        public final boolean collectOpenData(AbstractOpenCommand.OpenData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.addFlags(ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT);
            data.setLocation(this.m_softwareSystem.getUniqueExistingChild(Files.class).getSystemDirectory().getFile());
            return true;
        }

        @Override
        public boolean confirmPreRefreshActions(PrepareRefreshResult result) {
            assert (result != null) : "Parameter 'result' of method 'confirmPreRefreshActions' must not be null";
            return true;
        }

        @Override
        public boolean answerPreRefreshQuestion(PrepareRefreshResult.Question question) {
            assert (question != null) : "Parameter 'question' of method 'answerPreRefreshQuestion' must not be null";
            return false;
        }

        @Override
        public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean undoHistoryWillBeCleared) {
            return false;
        }
    }
}

