/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IBalancedDependencyRepresentationExtension;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependency;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependencyRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public final class ExpandBalancedDependencyCommand
extends SonargraphCommand {
    private final BalancedDependency m_expandedNode;
    private final BalancedDependencyRepresentation m_representation;

    public ExpandBalancedDependencyCommand(ISoftwareSystemProvider provider, BalancedDependencyRepresentation representation, BalancedDependency expandedNode) {
        super(provider);
        assert (expandedNode != null) : "Parameter 'expanded' of method 'ExpandBalancedDependencyCommand' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'ExpandBalancedDependencyCommand' must not be null";
        this.m_expandedNode = expandedNode;
        this.m_representation = representation;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EXPAND_BALANCED_DEPENDENCY;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        this.getController().getSoftwareSystem().getExtension(IBalancedDependencyRepresentationExtension.class).expandDependencyRepresentation(workerContext, this.m_representation, this.m_expandedNode);
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.BLOCKING;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result enabled = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            enabled.addErrorMessage("No software system opened");
        }
        if (this.m_representation == null) {
            enabled.addErrorMessage("There should be a Symmetric Dependency representation to perform the expansion");
        }
        if (this.m_expandedNode == null) {
            enabled.addErrorMessage("No selection specified");
        }
        return enabled;
    }

    public BalancedDependencyRepresentation getRepresentation() {
        return this.m_representation;
    }
}

