/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IAnalyzerExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class ApplyEditedConfigurationCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public static AnalyzerConfiguration getConfigurationForEdit(ISoftwareSystemProvider provider, IAnalyzerId analyzerId) {
        assert (provider != null) : "Parameter 'provider' of method 'getConfigurationForEdit' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'getConfigurationForEdit' must not be null";
        return provider.getSoftwareSystem().getExtension(IAnalyzerExtension.class).getConfigurationForEdit(analyzerId);
    }

    public ApplyEditedConfigurationCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.APPLY_EDITED_CONFIGURATION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        ConfigurationData data = new ConfigurationData();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IAnalyzerExtension.class).applyEditedConfiguration(workerContext, data.getConfiguration());
        ((IInteraction)this.getInteraction()).processApplyResult(result);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this == obj;
    }

    @Override
    public int hashCode() {
        return ((Object)this).hashCode();
    }

    public static final class ConfigurationData
    implements ICommandInteractionData {
        private AnalyzerConfiguration m_configuration;

        public void setConfiguration(AnalyzerConfiguration configuration) {
            assert (configuration != null) : "Parameter 'configuration' of method 'setConfiguration' must not be null";
            this.m_configuration = configuration;
        }

        AnalyzerConfiguration getConfiguration() {
            return this.m_configuration;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(ConfigurationData var1);

        public void processApplyResult(OperationResult var1);
    }
}

