/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.license.controller;

import com.hello2morrow.sonargraph.foundation.commandline.CommandLineParser;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.license.foundation.LicenseUtilities;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class SigningToolDevelopment {
    private static final String PRIVATE_KEY = "3082014B0201003082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0416021465F9C893E844E509AECAC940F21D1201AECE67C5";
    private static final byte[] KEY = LicenseUtilities.convert("3082014B0201003082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0416021465F9C893E844E509AECAC940F21D1201AECE67C5");
    private static final String ALGORITHM = "DSA";
    private static final String ENCODING = "ISO-8859-1";

    private SigningToolDevelopment() {
    }

    private static String createSignature(String content) {
        assert (content != null) : "Parameter 'content' of method 'createSignature' must not be null";
        try {
            Signature sig = Signature.getInstance(ALGORITHM);
            PrivateKey key = LicenseUtilities.getPrivate(KEY);
            sig.initSign(key);
            sig.update(content.getBytes(ENCODING));
            byte[] result = sig.sign();
            return LicenseUtilities.convert(result);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    public static String sign(String content) {
        assert (content != null) : "Parameter 'content' of method 'addSignature' must not be null";
        StringBuilder builder = new StringBuilder(content);
        builder.append("\n");
        String signature = SigningToolDevelopment.createSignature(builder.toString());
        builder.append("\n");
        builder.append("Signature=");
        builder.append(signature);
        return builder.toString();
    }

    public static void main(String[] args) {
        CommandLineParser.getInstance().addArguments(new String[]{"Path of the signed file to be created", "Content of the file"}, false);
        if (CommandLineParser.getInstance().parse(args)) {
            Object[] arguments = CommandLineParser.getInstance().getArguments();
            assert (arguments.length == 2) : "Unexpected number of arguments: " + Arrays.toString(arguments);
            String path = arguments[0];
            String content = arguments[1];
            assert (content != null) : "Parameter 'content' of method 'main' must not be null";
            content = content.replace("\r\n", "");
            content = content.replace("\r", "");
            content = content.replace("\t", "");
            StringBuilder builder = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(content, ";");
            while (tokenizer.hasMoreTokens()) {
                builder.append(tokenizer.nextToken().trim());
                if (!tokenizer.hasMoreTokens()) continue;
                builder.append("\n");
            }
            String signedContent = SigningToolDevelopment.sign(builder.toString());
            try {
                FileUtility.mkParentDirs((String)path);
                FileUtility.writeFile((String)path, (Charset)StandardCharsets.UTF_8, (String)signedContent, (boolean)false);
                System.out.println("File written to: " + new File(path).getCanonicalPath());
            }
            catch (IOException ex) {
                System.err.println(ExceptionUtility.collectAll((Throwable)ex));
            }
        } else {
            System.out.println(CommandLineParser.getInstance().usage());
        }
    }
}

