/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.pmd;

import com.hello2morrow.sonargraph.api.IDirectoryAccess;
import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.ModelVisitor;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.api.ResultSet;
import com.hello2morrow.sonargraph.plugin.IAnalyzerPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.pmd.SonargraphRenderer;
import com.hello2morrow.sonargraph.plugin.pmd.SourceFileRegistry;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.renderers.Renderer;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class PmdPlugin
extends SonargraphPlugin
implements IPluginAnalyzerContributor {
    public static final String ID = "com.hello2morrow.sonargraph.plugin.pmd";
    private static final Logger LOGGER = LoggerFactory.getLogger(PmdPlugin.class);
    private static final String JAVA = "Java";
    private static final java.util.logging.Logger NET_SOURCEFORGE_PMD = java.util.logging.Logger.getLogger("net.sourceforge.pmd");
    private final Map<Pair<RulePriority, PluginIssueSeverity>, IPluginIssueId> m_issueMap = new THashMap();
    private final SonargraphBooleanPluginAttribute m_cacheAttribute = new SonargraphBooleanPluginAttribute("cache", "Cache", "Use internal cache", "Basic", true);
    private final SonargraphStringPluginAttribute m_ruleSetsAttribute;
    private final SonargraphIntPluginAttribute m_minimumPriorityAttribute;
    private final SonargraphStringPluginAttribute m_priorityHighAttribute;
    private final SonargraphStringPluginAttribute m_priorityMediumHighAttribute;
    private final SonargraphStringPluginAttribute m_priorityMediumAttribute;
    private final SonargraphStringPluginAttribute m_priorityMediumLowAttribute;
    private final SonargraphStringPluginAttribute m_priorityLowAttribute;

    public PmdPlugin() {
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_cacheAttribute);
        this.m_ruleSetsAttribute = new SonargraphStringPluginAttribute("ruleSets", "Rule Sets", "Comma separated list of rule sets (if not specified an internal basic rule set is used)", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_ruleSetsAttribute);
        this.m_minimumPriorityAttribute = new SonargraphIntPluginAttribute("minimumPriority", "Minimum Priority", "Set the minimum priority threshold when loading Rules from RuleSets", "violations", 5, Arrays.asList("LOW", "MEDIUM_LOW", "MEDIUM", "MEDIUM_HIGH", "HIGH"), Arrays.asList(5, 4, 3, 2, 1));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_minimumPriorityAttribute);
        this.m_priorityHighAttribute = new SonargraphStringPluginAttribute("high", "HIGH", "Mark violations with rule priority 'HIGH' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_priorityHighAttribute);
        this.m_priorityMediumHighAttribute = new SonargraphStringPluginAttribute("mediumHigh", "MEDIUM_HIGH", "Mark violations with rule priority 'MEDIUM_HIGH' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_priorityMediumHighAttribute);
        this.m_priorityMediumAttribute = new SonargraphStringPluginAttribute("medium", "MEDIUM", "Mark violations with rule priority 'MEDIUM' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_priorityMediumAttribute);
        this.m_priorityMediumLowAttribute = new SonargraphStringPluginAttribute("mediumLow", "MEDIUM_LOW", "Mark violations with rule priority 'MEDIUM_LOW' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_priorityMediumLowAttribute);
        this.m_priorityLowAttribute = new SonargraphStringPluginAttribute("low", "LOW", "Mark violations with rule priority 'LOW' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_priorityLowAttribute);
        LOGGER.debug("[" + this.getId() + "] Instantiated: " + this.getHexReference());
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return ID;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Uses PMD to detect issues.";
    }

    public String getAvailableForLanguages() {
        return JAVA;
    }

    public String getPresentationName() {
        return "Sonargraph PMD Plugin";
    }

    public IPluginAnalyzerContributor getAnalyzerContributor() {
        return this;
    }

    public Set<String> getSupportedLanguages() {
        return Collections.singleton(JAVA);
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        LOGGER.debug("[" + this.getId() + "] Initialize: " + this.getHexReference());
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority nextRulePriority = rulePriorityArray[n2];
            PluginIssueSeverity[] pluginIssueSeverityArray = PluginIssueSeverity.values();
            int n3 = pluginIssueSeverityArray.length;
            int n4 = 0;
            while (n4 < n3) {
                PluginIssueSeverity nextPluginIssueSeverity = pluginIssueSeverityArray[n4];
                String nextIssueId = "PMD_" + nextRulePriority.name() + "_" + nextPluginIssueSeverity.name();
                String nextIssueName = "PMD " + nextRulePriority.name();
                IPluginIssueId nextPluginIssueId = contributor.createIssueId(nextIssueId, nextIssueName, nextPluginIssueSeverity, PluginIssueType.ELEMENT);
                this.m_issueMap.put((Pair<RulePriority, PluginIssueSeverity>)Pair.of((Object)nextRulePriority, (Object)nextPluginIssueSeverity), nextPluginIssueId);
                ++n4;
            }
            ++n2;
        }
        NET_SOURCEFORGE_PMD.addHandler((Handler)new SLF4JBridgeHandler());
        NET_SOURCEFORGE_PMD.setUseParentHandlers(false);
        NET_SOURCEFORGE_PMD.setLevel(Level.FINEST);
        LOGGER.debug("[" + this.getId() + "] Initialize - done");
    }

    public void cleared(IPluginContext context) {
        LOGGER.debug("[" + this.getId() + "] Cleared");
    }

    private String getCacheLocation(IPluginJavaAccess javaAccess) {
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'getCacheLocation' must not be null";
        File hiddenDataDirectory = javaAccess.getHiddenDataDirectory(this.getId());
        if (hiddenDataDirectory == null) {
            LOGGER.error("[" + this.getId() + "] Couldn't get hidden directory for cache");
            return null;
        }
        File cache = new File(hiddenDataDirectory, "cache");
        if (this.m_cacheAttribute.getValue().booleanValue()) {
            return cache.getAbsolutePath();
        }
        if (!cache.delete()) {
            LOGGER.warn("[" + this.getId() + "] Couldn't delete cache '" + cache.getAbsolutePath());
        }
        return null;
    }

    private PluginIssueSeverity getSeverityFromPriority(RulePriority priority) {
        assert (priority != null) : "Parameter 'priority' of method 'getSeverityFromPriority' must not be null";
        switch (priority) {
            case HIGH: {
                return PluginIssueSeverity.valueOf((String)this.m_priorityHighAttribute.getValue().toUpperCase());
            }
            case MEDIUM_HIGH: {
                return PluginIssueSeverity.valueOf((String)this.m_priorityMediumHighAttribute.getValue().toUpperCase());
            }
            case MEDIUM: {
                return PluginIssueSeverity.valueOf((String)this.m_priorityMediumAttribute.getValue().toUpperCase());
            }
            case MEDIUM_LOW: {
                return PluginIssueSeverity.valueOf((String)this.m_priorityMediumLowAttribute.getValue().toUpperCase());
            }
        }
        return PluginIssueSeverity.valueOf((String)this.m_priorityLowAttribute.getValue().toUpperCase());
    }

    private List<String> getRuleSets(IPluginContext context, IPluginJavaAccess javaAccess) {
        String[] splitted;
        assert (context != null) : "Parameter 'context' of method 'getRuleSets' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'getRuleSets' must not be null";
        String baseDirectory = javaAccess.getBaseDirectoryPath();
        LOGGER.info("[" + this.getId() + "] Base directory (parent directory of the  Sonargraph system directory): " + baseDirectory);
        String ruleSets = this.m_ruleSetsAttribute.getValue();
        if (ruleSets != null && !ruleSets.isEmpty() && (splitted = ruleSets.split(",")) != null && splitted.length > 0) {
            TreeSet<String> sorted = new TreeSet<String>();
            String[] stringArray = splitted;
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    String next = stringArray[n2];
                    String nextTrimmed = next.trim();
                    if (!nextTrimmed.isEmpty()) {
                        if (nextTrimmed.startsWith("./") || nextTrimmed.startsWith("../")) {
                            try {
                                Path nextPath = Paths.get(baseDirectory, nextTrimmed);
                                File nextFile = nextPath.toFile();
                                if (nextFile.exists()) {
                                    if (nextFile.isFile()) {
                                        sorted.add(nextFile.getCanonicalPath());
                                        break block11;
                                    }
                                    throw new IllegalArgumentException("Rule set path '" + nextTrimmed + "' is not a file");
                                }
                                throw new IllegalArgumentException("Rule set path '" + nextTrimmed + "' does not exist");
                            }
                            catch (IOException | InvalidPathException ex) {
                                throw new IllegalArgumentException("Unable to load rule set from '" + nextTrimmed + "'", ex);
                            }
                        }
                        sorted.add(nextTrimmed);
                    }
                }
                ++n2;
            }
            if (!sorted.isEmpty()) {
                return new ArrayList<String>(sorted);
            }
        }
        return Collections.singletonList("/defaultRuleSet.xml");
    }

    public void analyze(IAnalyzerPluginContext context, ResultSet result) {
        assert (context != null) : "Parameter 'context' of method 'analyze' must not be null";
        assert (result != null) : "Parameter 'result' of method 'analyze' must not be null";
        LOGGER.info("[" + this.getId() + "] Analyze");
        long startTime = System.currentTimeMillis();
        IPluginJavaAccess javaAccess = (IPluginJavaAccess)context.getAccess(IPluginJavaAccess.class);
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'analyze' must not be null";
        SourceFileRegistry sourceFileRegistry = new SourceFileRegistry();
        javaAccess.visitParserModel((ModelVisitor)sourceFileRegistry);
        if (sourceFileRegistry.isEmpty()) {
            LOGGER.info("[" + this.getId() + "] No Java source files found. Nothing to analyze.");
            return;
        }
        PMDConfiguration configuration = new PMDConfiguration();
        List<String> ruleSets = this.getRuleSets((IPluginContext)context, javaAccess);
        for (String next : ruleSets) {
            LOGGER.info("[" + this.getId() + "] Using rule set: " + next);
        }
        ruleSets.forEach(rs -> configuration.addRuleSet(rs));
        configuration.setMinimumPriority(RulePriority.valueOf((int)this.m_minimumPriorityAttribute.getValue()));
        String cacheLocation = this.getCacheLocation(javaAccess);
        configuration.setAnalysisCacheLocation(cacheLocation);
        LOGGER.info("[" + this.getId() + "] " + (String)(cacheLocation != null ? "Using cache location '" + cacheLocation + "'" : "Not using cache"));
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int numberThreads = Math.max(availableProcessors - 4, 1);
        LOGGER.info("[" + this.getId() + "] Using " + numberThreads + " threads (" + availableProcessors + " processors)");
        configuration.setThreads(numberThreads);
        assert (javaAccess != null) : "'javaAccess' of method 'analyze' must not be null";
        Throwable throwable = null;
        Object var13_15 = null;
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)configuration);){
            for (IModuleAccess module : javaAccess.getModules()) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                if (!JAVA.equalsIgnoreCase(module.getLanguage())) continue;
                for (IDirectoryAccess sourceRootDirectory : module.getSourceRootDirectories()) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    String nextPath = sourceRootDirectory.getAbsolutePath();
                    try {
                        Path nextToAdd = Paths.get(nextPath, new String[0]);
                        File nextToAddAsFile = nextToAdd.toFile();
                        if (nextToAddAsFile.exists()) {
                            if (nextToAddAsFile.isDirectory()) {
                                LOGGER.debug("[" + this.getId() + "] Include plain root directory: {}", (Object)nextPath);
                                pmd.files().addDirectory(nextToAdd);
                                continue;
                            }
                            LOGGER.debug("[" + this.getId() + "] Include compressed root directory: {}", (Object)nextPath);
                            pmd.files().addZipFile(nextToAdd);
                            continue;
                        }
                        LOGGER.warn("[" + this.getId() + "] Ignoring non existing source root directory: {}", (Object)nextPath);
                    }
                    catch (Exception e) {
                        LOGGER.warn("[" + this.getId() + "] Unable to add source root directory: " + nextPath, (Throwable)e);
                    }
                }
            }
            THashMap issues = new THashMap();
            RulePriority[] rulePriorityArray = RulePriority.values();
            int n = rulePriorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                RulePriority priority = rulePriorityArray[n2];
                issues.put(priority, this.m_issueMap.get(Pair.of((Object)priority, (Object)this.getSeverityFromPriority(priority))));
                ++n2;
            }
            pmd.addRenderer((Renderer)new SonargraphRenderer(context, result, (Map<RulePriority, IPluginIssueId>)issues, sourceFileRegistry));
            int numberOfFiles = pmd.files().getCollectedFiles().size();
            context.beginBlockOfWork(numberOfFiles);
            pmd.performAnalysis();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - startTime;
        LOGGER.info("[" + this.getId() + "] Analyze - done [" + (context.hasBeenCanceled() ? "canceled" : "finished") + " after " + millis / 1000L + " seconds]");
    }
}

