/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.AngularJsonFile;
import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.IJsonFileManager;
import com.hello2morrow.sonargraph.plugin.angular.JsonFile;
import com.hello2morrow.sonargraph.plugin.angular.NxJsonFile;
import com.hello2morrow.sonargraph.plugin.angular.NxProjectJsonFile;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

final class TsConfigJsonFile
extends JsonFile {
    private final AngularJsonFile m_angularJsonFile;
    private final NxJsonFile m_nxJsonFile;
    private final TsConfigJsonFile m_parentTsConfigJsonFile;

    TsConfigJsonFile(Path path, IJsonFileManager manager, IExecutionContext context) throws IOException {
        super(path, manager);
        assert (context != null) : "Parameter 'context' of method 'TsConfigJsonFile' must not be null";
        Path angularPath = path.getParent().resolve("angular.json");
        this.m_angularJsonFile = manager.computeIfAbsent(angularPath, () -> new AngularJsonFile(angularPath, manager, context));
        Path nxPath = path.getParent().resolve("nx.json");
        this.m_nxJsonFile = manager.computeIfAbsent(nxPath, () -> new NxJsonFile(nxPath, manager, context));
        String ext = (String)this.getDocumentContext().read("$.extends", new Predicate[0]);
        if (ext != null) {
            Path parentPath = this.getPath().getParent().resolve(ext);
            this.m_parentTsConfigJsonFile = manager.computeIfAbsent(parentPath, () -> new TsConfigJsonFile(parentPath, manager, context));
        } else {
            this.m_parentTsConfigJsonFile = null;
        }
    }

    private Collection<Path> getSourceRoots(Path path, boolean ignoreProject) {
        if (this.m_angularJsonFile != null && (this.m_angularJsonFile.getRootsByConfig().containsKey(path) || ignoreProject)) {
            if (this.m_angularJsonFile.getRootsByConfig().containsKey(path)) {
                return List.of(this.m_angularJsonFile.getRootsByConfig().get(path));
            }
            return this.m_angularJsonFile.getRootsByConfig().values();
        }
        if (this.m_nxJsonFile != null) {
            if (ignoreProject) {
                return this.m_nxJsonFile.getNxProjectJsonFiles().stream().map(NxProjectJsonFile::getSourceRoot).collect(Collectors.toList());
            }
            return this.m_nxJsonFile.getSourceFor(path).map(List::of).orElse(Collections.emptyList());
        }
        if (this.m_parentTsConfigJsonFile != null) {
            return this.m_parentTsConfigJsonFile.getSourceRoots(path, ignoreProject);
        }
        return Collections.emptyList();
    }

    Collection<Path> getSourceRoots() {
        Collection<Path> result = this.getSourceRoots(this.getPath(), false);
        return !result.isEmpty() ? result : this.getSourceRoots(this.getPath(), true);
    }
}

