/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GeneratedInstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromBundle;

public class InstCompilerDefinitionDelta
implements ISettingsDelta {
    private InstCompilerDefinition m_original;
    private InstCompilerDefinition m_newDefinition;
    private boolean m_isOriginalActive = false;
    private boolean m_isNewDefActive = false;

    public InstCompilerDefinitionDelta(InstCompilerDefinition original, boolean isOriginalActive, NamedElement parent) {
        assert (original != null) : "Parameter 'original' of method 'InstCompilerDefinitionDelta' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'InstCompilerDefinitionDelta' must not be null";
        this.m_original = original;
        this.m_isNewDefActive = this.m_isOriginalActive = isOriginalActive;
        this.m_newDefinition = InstCompilerDefinitionBuilder.copy(original, parent, false);
    }

    public InstCompilerDefinitionDelta(InstCompilerDefinition original, boolean isOriginalActive, NamedElement parent, boolean createModifiableDeltaForBundleDefinition) {
        assert (original != null) : "Parameter 'original' of method 'InstCompilerDefinitionDelta' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'InstCompilerDefinitionDelta' must not be null";
        this.m_original = original;
        this.m_isNewDefActive = this.m_isOriginalActive = isOriginalActive;
        this.m_newDefinition = InstCompilerDefinitionBuilder.copy(original, parent, createModifiableDeltaForBundleDefinition);
    }

    public void setModified(InstCompilerDefinition modified) {
        if (this.m_newDefinition != null) {
            this.dispose();
        }
        this.m_newDefinition = modified;
    }

    public boolean isModified() {
        return !InstCompilerDefinitionBuilder.areEqual(this.m_original, this.m_newDefinition) || this.m_isOriginalActive != this.m_isNewDefActive;
    }

    public void reset() {
        NamedElement parent = this.m_newDefinition.getParent();
        this.dispose();
        this.m_newDefinition = InstCompilerDefinitionBuilder.copy(this.m_original, parent);
    }

    public void dispose() {
        if (this.m_newDefinition == null) {
            return;
        }
        NamedElement parent = this.m_newDefinition.getParent();
        if (parent.getChildren().contains((Object)this.m_newDefinition)) {
            parent.removeChild((NamedElement)this.m_newDefinition);
        }
        this.m_newDefinition.setParent(null);
        this.m_newDefinition = null;
    }

    public InstCompilerDefinition getModified() {
        return this.m_newDefinition;
    }

    public InstCompilerDefinition getOriginal() {
        return this.m_original;
    }

    public void setActive(boolean isActive) {
        if (this.m_isNewDefActive == isActive) {
            return;
        }
        this.m_isNewDefActive = isActive;
    }

    public boolean isActive() {
        return this.m_isNewDefActive;
    }

    public boolean isOriginalActive() {
        return this.m_isOriginalActive;
    }

    public boolean isEditable() {
        if (this.m_original == null) {
            return true;
        }
        if (this.m_original instanceof InstCompilerDefinitionFromBundle) {
            return false;
        }
        return !(this.m_original instanceof GeneratedInstCompilerDefinition);
    }
}

