/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICxxConfigFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CxxConfigSettingsBlock {
    private final List<String> m_sysIncludes = new ArrayList<String>();
    private final List<String> m_options = new ArrayList<String>();
    private boolean m_unsignedChars;
    private boolean m_c99;
    private boolean m_variableLengthArrays;
    private boolean m_enableExceptionHandling;

    public void addOption(String opt, ICxxConfigFile config) {
        assert (opt != null && opt.length() > 0) : "Parameter 'opt' of method 'addOption' must not be empty";
        switch (opt) {
            case "--vla": {
                this.m_variableLengthArrays = true;
                break;
            }
            case "--unsigned_chars": {
                this.m_unsignedChars = true;
                break;
            }
            case "--c99": {
                this.m_c99 = true;
                break;
            }
            case "-x": {
                this.m_enableExceptionHandling = true;
                break;
            }
            case "--gcc": {
                config.activateGnuMode();
                break;
            }
            case "--g++": {
                config.activateGnuMode();
                break;
            }
            default: {
                if (opt.startsWith("--gnu_version=")) {
                    config.activateGnuMode();
                    config.setGnuVersion(opt.substring(14));
                } else if (opt.startsWith("--microsoft_version=")) {
                    config.activateMicrosoftMode();
                    config.setMicrosoftVersion(opt.substring(20));
                }
                if (opt.startsWith("--error_limit=")) break;
                this.m_options.add(opt);
            }
            case "--gnu_version": 
            case "--no_microsoft": 
            case "--parse_templates": 
            case "--no_g++": 
            case "--no_gcc": 
            case "-tnone": 
            case "--microsoft_version": 
        }
    }

    public void addSysIncludeDirectory(String dir) {
        assert (dir != null && dir.length() > 0) : "Parameter 'dir' of method 'addSysInclude' must not be empty";
        this.m_sysIncludes.add(dir);
    }

    public List<String> getSysIncludeDirectories() {
        return Collections.unmodifiableList(this.m_sysIncludes);
    }

    public List<String> getOptions() {
        return Collections.unmodifiableList(this.m_options);
    }

    public boolean isEnableExceptionHandling() {
        return this.m_enableExceptionHandling;
    }

    public boolean isUnsignedChars() {
        return this.m_unsignedChars;
    }

    public boolean isC99() {
        return this.m_c99;
    }

    public boolean isVariableLengthArrays() {
        return this.m_variableLengthArrays;
    }
}

