/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.settings.ConfigurationLevel;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ForcedIncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GenericCompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.MacFrameworkAccessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.Macro;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SysInclude;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InstIgnoredOptionLineIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InstNonExistingIncludeIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InvalidSysIncludeIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemIgnoredOptionLineIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemInvalidSysIncludeIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemNonExistingIncludeIssue;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerOptions
extends NamedElementContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilerOptions.class);
    private String m_name;
    private List<String> m_skippedLines = new ArrayList<String>(0);

    public CompilerOptions(NamedElement parent) {
        super(parent);
    }

    public CompilerOptions(NamedElement parent, String name) {
        super(parent);
        assert (name != null && name.length() > 0) : "Parameter 'm_name' of method 'CompilerOptions' must not be empty";
        this.m_name = name;
    }

    public String getShortName() {
        return this.m_name;
    }

    public void setName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
        this.m_name = name;
    }

    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public void addOptions(Collection<String> options) {
        assert (options != null) : "Parameter 'options' of method 'addOptions' must not be null";
        this.m_skippedLines = new ArrayList<String>(0);
        for (String line : options) {
            this.addOption(line);
        }
    }

    private void handleMacroValue(String macro) {
        block11: {
            assert (macro != null) : "Parameter 'macro' of method 'handleMacroValue' must not be null";
            StringReader reader = new StringReader(macro);
            try {
                int c;
                int delim = -1;
                int nesting = 0;
                StringBuilder result = new StringBuilder();
                result.append("-D");
                while ((c = reader.read()) != -1) {
                    if (c == delim) {
                        result.append((char)c);
                        delim = -1;
                        continue;
                    }
                    if (delim != -1) {
                        result.append((char)c);
                        continue;
                    }
                    if (c == 34 || c == 39) {
                        result.append((char)c);
                        delim = c;
                        continue;
                    }
                    if (c == 40 || c == 91 || c == 123) {
                        result.append((char)c);
                        ++nesting;
                        continue;
                    }
                    if (c == 41 || c == 93 || c == 125) {
                        result.append((char)c);
                        --nesting;
                        continue;
                    }
                    if (c == 44 && nesting == 0) {
                        this.addChildAndOmitDuplicate(new Macro((NamedElement)this, result.toString()));
                        result.setLength(0);
                        result.append("-D");
                        continue;
                    }
                    result.append((char)c);
                }
                if (result.length() > 2) {
                    this.addChildAndOmitDuplicate(new Macro((NamedElement)this, result.toString()));
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)("Failed to process value '" + macro + "': " + e.getMessage()));
            }
        }
    }

    public ICompilerOption addOption(String line) {
        assert (line != null) : "Parameter 'line' of method 'processOptionLine' must not be null";
        String trimmedLine = line.trim();
        if (trimmedLine.length() == 0) {
            return null;
        }
        if (trimmedLine.startsWith("#")) {
            return null;
        }
        if (trimmedLine.startsWith("-I") && trimmedLine.length() > 2) {
            return this.addChildAndOmitDuplicate(IncludeOption.create((NamedElement)this, trimmedLine));
        }
        if (trimmedLine.startsWith("--include=") && trimmedLine.length() > 10) {
            return this.addChildAndOmitDuplicate(IncludeOption.create((NamedElement)this, "-I" + trimmedLine.substring("--include=".length())));
        }
        if (trimmedLine.startsWith("-D") && trimmedLine.length() > 2) {
            this.handleMacroValue(trimmedLine.substring(2));
        } else if (trimmedLine.startsWith("--sys_include")) {
            SysInclude sysInclude = SysInclude.create((NamedElement)this, trimmedLine);
            if (sysInclude != null) {
                this.addChildAndOmitDuplicate(sysInclude);
            }
        } else if (Platform.isMac() && trimmedLine.startsWith("-F")) {
            String symbolicIncludeDir = MacFrameworkAccessor.getInstance().getSymbolicFrameworkDirectory(trimmedLine.substring(2));
            if (symbolicIncludeDir != null) {
                this.addChildAndOmitDuplicate(IncludeOption.create((NamedElement)this, "-I" + symbolicIncludeDir));
            }
        } else if (trimmedLine.startsWith("--preinclude")) {
            this.addChildAndOmitDuplicate(new ForcedIncludeOption((NamedElement)this, trimmedLine));
        } else if (trimmedLine.startsWith("-")) {
            this.addChildAndOmitDuplicate(new GenericCompilerOption((NamedElement)this, trimmedLine));
        } else {
            this.m_skippedLines.add(trimmedLine);
        }
        return null;
    }

    protected ICompilerOption addChildAndOmitDuplicate(ICompilerOption opt) {
        boolean hasSameChild;
        assert (opt != null) : "'opt' cannot be null here";
        NamedElement child = opt.getElement();
        String fqNamePart = child.getFullyQualifiedNamePart();
        boolean bl = hasSameChild = this.getChildren(c -> c.getFullyQualifiedNamePart().equals(fqNamePart), child.getClass()).size() > 0;
        if (!hasSameChild) {
            super.addChild(child);
            return opt;
        }
        LOGGER.debug("Skipping duplicate compiler option: " + ((ICompilerOption)child).getValue());
        return null;
    }

    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        for (ICompilerOption option : this.getChildren(ICompilerOption.class)) {
            options.add(option.getValueForPersistence());
        }
        return Collections.unmodifiableList(options);
    }

    public static boolean areEqual(CompilerOptions options1, CompilerOptions options2) {
        if (options1 == null && options2 == null) {
            return true;
        }
        if (options1 == options2) {
            return true;
        }
        if (options1 == null || options2 == null) {
            return false;
        }
        List<String> optionList1 = options1.getOptions();
        List<String> optionList2 = options2.getOptions();
        if (optionList1.size() != optionList2.size()) {
            return false;
        }
        int i = 0;
        while (i < optionList1.size()) {
            if (!optionList1.get(i).equals(optionList2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Result validate(boolean addIssues, ConfigurationLevel level) {
        assert (level != null) : "Parameter 'level' of method 'validate' must not be null";
        if (addIssues) {
            this.removeIssues();
        }
        StringBuilder errorMessage = new StringBuilder();
        for (ICompilerOption option : this.getChildren(ICompilerOption.class)) {
            Result optionResult = option.validate();
            if (!optionResult.isFailure()) continue;
            if (addIssues && option instanceof IncludeOption) {
                if (level == ConfigurationLevel.INSTALLATION) {
                    this.addIssue((Issue)new InstNonExistingIncludeIssue((NamedElement)this, optionResult.getErrorMessage()));
                } else {
                    this.addIssue((Issue)new SystemNonExistingIncludeIssue((NamedElement)this, optionResult.getErrorMessage()));
                }
            } else if (addIssues && option instanceof SysInclude) {
                if (level == ConfigurationLevel.INSTALLATION) {
                    this.addIssue((Issue)new InvalidSysIncludeIssue((NamedElement)this, optionResult.getErrorMessage()));
                } else {
                    this.addIssue((Issue)new SystemInvalidSysIncludeIssue((NamedElement)this, optionResult.getErrorMessage()));
                }
            } else if (addIssues) assert (false) : "Issues of option type '" + option.getClass().getSimpleName() + "' are not supported";
            errorMessage.append(optionResult.getErrorMessage()).append(StringUtility.LINE_SEPARATOR);
        }
        if (!this.m_skippedLines.isEmpty()) {
            for (String line : this.m_skippedLines) {
                if (addIssues) {
                    if (level == ConfigurationLevel.INSTALLATION) {
                        this.addIssue((Issue)new InstIgnoredOptionLineIssue((NamedElement)this, line));
                    } else {
                        this.addIssue((Issue)new SystemIgnoredOptionLineIssue((NamedElement)this, line));
                    }
                }
                errorMessage.append("# Ignoring line '" + line + "'").append(StringUtility.LINE_SEPARATOR);
            }
        }
        Result result = new Result();
        if (errorMessage.length() > 0) {
            result.addErrorMessage(errorMessage.toString());
        }
        return result;
    }

    public List<String> getSkippedOptionLines() {
        return Collections.unmodifiableList(this.m_skippedLines);
    }
}

