/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.UnresolvedWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SignatureElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignature;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CppExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.ModuleCompilerOptionsValidator;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusVisualStudioExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.RefreshMessageCause;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.ICPlusPlusWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusManualWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusVisualStudioProjectDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BasePathForIncludes;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CppSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SettingsBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusManualModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusVsProjectFileBasedModule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusWorkspaceExtension
extends CppExtension
implements ICPlusPlusWorkspaceExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusWorkspaceExtension.class);
    private static final String SEPARATOR = "; ";
    private final SoftwareSystem m_softwareSystem;

    CPlusPlusWorkspaceExtension(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'CPlusPlusWorkspaceExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    public static void finishModuleCreation(Installation installation, CPlusPlusManualModule module) {
        assert (installation != null) : "Parameter 'installation' of method 'finishModuleCreation' must not be null";
        assert (module != null) : "Parameter 'module' of method 'finishModuleCreation' must not be null";
        Workspace workspace = (Workspace)module.getParent(Workspace.class, new Class[0]);
        if (workspace.getUniqueChild(CPlusPlusSystemSettings.class) == null) {
            workspace.addChild((NamedElement)new CPlusPlusSystemSettings((NamedElement)workspace));
        }
        ModuleSettings settings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        CPlusPlusInstallationSettings instSettings = (CPlusPlusInstallationSettings)((Object)installation.getUniqueChild(CPlusPlusInstallationSettings.class));
        ArrayList<String> compilerDefinitionNames = new ArrayList<String>();
        for (InstCompilerDefinition nextDefinition : instSettings.getChildren(InstCompilerDefinition.class)) {
            compilerDefinitionNames.add(nextDefinition.getName());
        }
        SettingsBuilder.addOptionsForMissingDefinitions((NamedElement)settings, compilerDefinitionNames);
        settings.addChild((NamedElement)CPlusPlusWorkspaceExtension.createSignatureElement(installation, module));
        CPlusPlusWorkspaceExtension.validateManualModule(installation, module);
    }

    private static ValidationResult validateManualModule(Installation installation, CPlusPlusManualModule module) {
        assert (installation != null) : "Parameter 'installation' of method 'validateManualModule' must not be null";
        assert (module != null) : "Parameter 'module' of method 'validateManualModule' must not be null";
        InstCompilerDefinition activeDefinition = CPlusPlusWorkspaceExtension.getActiveCompilerDefinition(installation);
        if (activeDefinition == null) {
            return new ValidationResult(false);
        }
        ModuleSettings settings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        ModuleCompilerOptions options = null;
        options = (ModuleCompilerOptions)((Object)settings.getUniqueChild((NamedElement.IFilter)new NameFilter(activeDefinition.getName()), ModuleCompilerOptions.class));
        if (options == null) {
            return new ValidationResult(false);
        }
        assert (options != null) : "Parameter 'options' of method 'validateManualModule' must not be null";
        ModuleCompilerOptionsValidator validator = new ModuleCompilerOptionsValidator(options);
        return validator.validate(true);
    }

    private List<CPlusPlusManualModule> validateManualModulesConfiguration() {
        ArrayList<CPlusPlusManualModule> modulesWithIssues = new ArrayList<CPlusPlusManualModule>();
        Installation installation = ((ISoftwareSystemProvider)this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation();
        for (CPlusPlusManualModule nextModule : ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusManualModule.class)) {
            if (!CPlusPlusWorkspaceExtension.validateManualModule(installation, nextModule).isFailure()) continue;
            modulesWithIssues.add(nextModule);
        }
        return modulesWithIssues;
    }

    @Override
    public List<Module> validateModulesConfiguration(PrepareRefreshResult result) {
        assert (result != null) : "Parameter 'result' of method 'validateModulesConfiguration' must not be null";
        HashSet<Module> modulesWithIssues = new HashSet<Module>();
        Workspace workspace = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        modulesWithIssues.addAll(this.validateManualModulesConfiguration());
        if (workspace.getChildren(CPlusPlusVsProjectFileBasedModule.class).size() > 0) {
            modulesWithIssues.addAll(((CPlusPlusVisualStudioExtension)this.m_softwareSystem.getExtension(CPlusPlusVisualStudioExtension.class)).validateModulesConfiguration(result));
        }
        for (Module nextModuleWithIssue : modulesWithIssues) {
            result.addError((OperationResult.IMessageCause)RefreshMessageCause.MODULES_HAS_ERRORS, "Module: " + nextModuleWithIssue.getName(), new Object[0]);
        }
        return new ArrayList<Module>(modulesWithIssues);
    }

    public static SignatureElement createSignatureElement(Installation installation, CPlusPlusModule module) {
        CppSourceFileExtensions extensions;
        assert (module != null) : "Parameter 'module' of method 'createSignature' must not be null";
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        StringBuilder text = new StringBuilder();
        BasePathForIncludes baseDir = (BasePathForIncludes)((Object)moduleSettings.getUniqueChild(BasePathForIncludes.class));
        if (baseDir != null) {
            text.append(baseDir.getName()).append(SEPARATOR);
        }
        if ((extensions = (CppSourceFileExtensions)((Object)moduleSettings.getUniqueChild(CppSourceFileExtensions.class))) != null) {
            text.append(extensions.toString()).append(SEPARATOR);
        }
        text.append(CPlusPlusWorkspaceExtension.getActiveModuleOptionsAsString(installation, moduleSettings));
        LOGGER.debug("Create signature for text: " + text.toString());
        return new ModuleSettingsSignature((NamedElement)moduleSettings, HashSupport.SHA.getHexString(text.toString()));
    }

    private static String getActiveModuleOptionsAsString(Installation installation, ModuleSettings moduleSettings) {
        InstCompilerDefinition activeCompilerDefinition = CPlusPlusWorkspaceExtension.getActiveCompilerDefinition(installation);
        if (activeCompilerDefinition == null) {
            return "";
        }
        ModuleCompilerOptions activeModuleOptions = (ModuleCompilerOptions)((Object)moduleSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(activeCompilerDefinition.getName()), ModuleCompilerOptions.class));
        if (activeModuleOptions != null) {
            return StringUtility.concat(activeModuleOptions.getOptions(), (String)SEPARATOR);
        }
        return "";
    }

    @Override
    public WorkspaceDependency createWorkspaceDependency(CPlusPlusModule from, CPlusPlusModule to, CPlusPlusWorkspaceDependency.DependencyType type) {
        assert (from != null) : "Parameter 'from' of method 'createWorkspaceDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'createWorkspaceDependency' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createWorkspaceDependency' must not be null";
        CPlusPlusWorkspaceDependency dependency = null;
        switch (type) {
            case MANUAL_DEPENDENCY: {
                dependency = new CPlusPlusManualWorkspaceDependency((IWorkspaceDependencyElement)from, (IWorkspaceDependencyElement)to);
                break;
            }
            case VISUAL_STUDIO_PROJECT_DEPENDENCY: {
                dependency = new CPlusPlusVisualStudioProjectDependency((IWorkspaceDependencyElement)from, (IWorkspaceDependencyElement)to);
                break;
            }
            default: {
                LOGGER.error("Unsupported dependency type {}", (Object)type.getStandardName());
            }
        }
        if (dependency != null) {
            dependency.setAdditionalDependencyData(new WorkspaceDependency.AdditionalDependencyData());
        }
        return dependency;
    }

    public static WorkspaceDependency createWorkspaceDependency(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to, String toId, String toName, CPlusPlusWorkspaceDependency.DependencyType type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        assert (from != null) : "Parameter 'from' of method 'createWorkspaceDependency' must not be null";
        assert (toId != null && toId.length() > 0) : "Parameter 'toId' of method 'createWorkspaceDependency' must not be empty";
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'createWorkspaceDependency' must not be empty";
        assert (type != null) : "Parameter 'type' of method 'createWorkspaceDependency' must not be null";
        assert (dependencyData != null) : "Parameter 'dependencyData' of method 'createWorkspaceDependency' must not be null";
        CPlusPlusWorkspaceDependency dependency = null;
        IWorkspaceDependencyElement endpoint = to;
        boolean isEndpointCreated = false;
        if (to == null) {
            NamedElement parent = ((NamedElement)from.getUnderlyingObject()).getParent();
            UnresolvedWorkspaceDependencyElement unresolved = Module.addUnresolvedWorkspaceDependencyElement((NamedElement)parent, (String)toName, (String)toId);
            endpoint = unresolved;
            isEndpointCreated = true;
        }
        switch (type) {
            case MANUAL_DEPENDENCY: {
                dependency = new CPlusPlusManualWorkspaceDependency(from, endpoint);
                break;
            }
            case VISUAL_STUDIO_PROJECT_DEPENDENCY: {
                dependency = new CPlusPlusVisualStudioProjectDependency(from, endpoint);
                break;
            }
            default: {
                LOGGER.error("Unsupported dependency type {}", (Object)type.getStandardName());
            }
        }
        if (dependency == null) {
            if (isEndpointCreated) {
                ((UnresolvedWorkspaceDependencyElement)endpoint).remove();
            }
        } else {
            dependency.setAdditionalDependencyData(dependencyData);
        }
        return dependency;
    }
}

