/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppExternalHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppIncludeDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusInternalHeaders;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusUnboundComponents;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CppElementVisitor;
import java.util.ArrayList;
import java.util.List;

public final class ComponentRemovalVisitor
extends CppElementVisitor {
    private final SoftwareSystem m_softwareSystem;
    private final List<CppSourceFile> m_projectSources = new ArrayList<CppSourceFile>();
    private final List<CppHeaderFile> m_projectHeaders = new ArrayList<CppHeaderFile>();
    private final List<CppExternalHeaderFile> m_fakeExternals = new ArrayList<CppExternalHeaderFile>();

    public ComponentRemovalVisitor(SoftwareSystem softwareSystem) {
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public void visitCppSourceFile(CppSourceFile element) {
        if (element.getTimestamp() != 0L) {
            this.m_projectSources.add(element);
            element.getFile();
        }
    }

    @Override
    public void visitCppHeaderFile(CppHeaderFile element) {
        assert (element != null) : "Parameter 'element' of method 'visitCppHeaderFile' must not be null";
        if (element.getTimestamp() != 0L) {
            this.m_projectHeaders.add(element);
            element.getFile();
        }
    }

    @Override
    public void visitCppExternalHeaderFile(CppExternalHeaderFile obj) {
        if (obj.getTimestamp() != 0L) {
            this.m_fakeExternals.add(obj);
            obj.getFile();
        }
    }

    @Override
    public void visitCppIncludeDirectory(CppIncludeDirectory element) {
        if (!element.isSystemInclude()) {
            this.visitChildrenOf((NamedElement)element);
        }
    }

    public void visitWorkspace(Workspace ws) {
        this.visitChildrenOf((NamedElement)ws);
        CPlusPlusInternalHeaders internalHeaderRoot = (CPlusPlusInternalHeaders)((Object)ws.getUniqueChild(CPlusPlusInternalHeaders.class));
        boolean createdHeaderRoot = false;
        if (internalHeaderRoot == null) {
            internalHeaderRoot = new CPlusPlusInternalHeaders((NamedElement)ws);
            ws.addChild((NamedElement)internalHeaderRoot);
            createdHeaderRoot = true;
        }
        for (CppHeaderFile header : this.m_projectHeaders) {
            if (!(header.getParent() instanceof CppComponent)) continue;
            header.changeParent((NamedElement)internalHeaderRoot, true);
        }
        for (CppSourceFile source : this.m_projectSources) {
            if (!(source.getParent() instanceof CppComponent)) continue;
            source.changeParent(source.getParent().getParent(), true);
        }
        for (CppExternalHeaderFile extHeader : this.m_fakeExternals) {
            CppHeaderFile header = new CppHeaderFile((IModelServiceProvider)this.m_softwareSystem, (NamedElement)internalHeaderRoot, extHeader);
            internalHeaderRoot.addChild((NamedElement)header);
            this.m_projectHeaders.add(header);
            extHeader.remove();
        }
        ws.removeChildren(new Class[]{CPlusPlusUnboundComponents.class});
        if (createdHeaderRoot && !internalHeaderRoot.hasChildren()) {
            internalHeaderRoot.remove();
        }
    }

    public List<CppSourceFile> getProjectSources() {
        return this.m_projectSources;
    }

    public List<CppHeaderFile> getProjectHeaders() {
        return this.m_projectHeaders;
    }
}

