/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.api;

import com.hello2morrow.sonargraph.api.Any;
import com.hello2morrow.sonargraph.api.AnyFactory;
import com.hello2morrow.sonargraph.api.IPluginProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.WebProperty;
import java.util.ArrayList;
import java.util.List;

public final class WebUtilities {
    private WebUtilities() {
    }

    public static String removeVariablesFromPath(String path) {
        assert (path != null) : "Parameter 'path' of method 'removeVariablesFromPath' must not be null";
        if (path.isEmpty()) {
            return path;
        }
        ArrayList<String> variables = new ArrayList<String>();
        StringBuilder currentVar = new StringBuilder();
        boolean startDetected = false;
        char previous = '\u0000';
        char[] cArray = path.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '{' && previous != '$') {
                startDetected = true;
            } else if (c == '}') {
                if (startDetected) {
                    variables.add(currentVar.toString());
                    currentVar.delete(0, currentVar.length());
                    startDetected = false;
                }
            } else if (startDetected) {
                currentVar.append(c);
            }
            previous = c;
            ++n2;
        }
        String result = path;
        for (String next : variables) {
            result = result.replaceFirst("\\{" + next + "\\}", "{}");
        }
        return result;
    }

    public static boolean match(IPluginProgrammingElementAccess webResource, String pathToMatch, String path, List<String> httpMethodTypes) {
        assert (webResource != null) : "Parameter 'webResource' of method 'match' must not be null";
        assert (pathToMatch != null) : "Parameter 'pathToMatch' of method 'match' must not be null";
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'match' must not be empty";
        assert (httpMethodTypes != null && httpMethodTypes.size() > 0) : "Parameter 'method' of method 'match' must not be empty";
        Any otherPathToMatch = webResource.getProperty(WebProperty.PATH_TO_MATCH.getStandardName());
        if (otherPathToMatch != null && otherPathToMatch.asString().equals(pathToMatch) || path.equals(webResource.getShortName())) {
            List<Any> methods = webResource.getProperty(WebProperty.HTTP_METHOD.getStandardName()).asList();
            for (String next : httpMethodTypes) {
                if (!methods.contains(AnyFactory.createFrom(next))) continue;
                return true;
            }
        }
        return false;
    }
}

