/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.analysis;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedExternalLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaLanguage;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaProviderId;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMetricLevel;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaMetricId;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;

public final class JavaVisibilityMetricsAnalyzerAdapter
extends AnalyzerAdapter {
    public static JavaAnalyzerId ID = JavaAnalyzerId.JAVA_VISIBILITY_METRICS;
    private final IMetricDescriptor m_classPublicVisibility;
    private final IMetricDescriptor m_packagePublicVisibility;
    private final IMetricDescriptor m_averageClassPublicVisibility;
    private final IMetricDescriptor m_averagePackagePublicVisibility;

    public JavaVisibilityMetricsAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, (IConfigurableAnalyzerId)JavaAnalyzerId.JAVA_VISIBILITY_METRICS);
        MetricProvider mp = ((IMetricsProvider)this.getInstallation().getExtension(IMetricsProvider.class)).getMetricProvider((IProviderId)JavaProviderId.INSTANCE);
        this.m_classPublicVisibility = this.addMetricDescriptorIfNotExistent(mp, JavaMetricId.JAVA_CLASS_MEMBER_VISIBILITY, (IMetricLevel)CoreMetricLevel.TYPE, null);
        this.m_averagePackagePublicVisibility = this.addMetricDescriptorIfNotExistent(mp, JavaMetricId.JAVA_AVERAGE_PACKAGE_PUBLIC_VISIBILITY, (IMetricLevel)CoreMetricLevel.MODULE, null);
        Predicate<NamedElement> modulePredicate = new Predicate<NamedElement>(){

            @Override
            public boolean test(NamedElement element) {
                if (!$assertionsDisabled && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'test' must not be null");
                }
                return element instanceof LogicalModuleNamespace;
            }
        };
        this.m_packagePublicVisibility = this.addMetricDescriptorIfNotExistent(mp, JavaMetricId.JAVA_PACKAGE_PUBLIC_VISIBILITY, JavaMetricLevel.JAVA_PACKAGE, modulePredicate);
        this.m_averageClassPublicVisibility = this.addMetricDescriptorIfNotExistent(mp, JavaMetricId.JAVA_AVERAGE_CLASS_MEMBER_VISIBILITY, JavaMetricLevel.JAVA_PACKAGE, modulePredicate);
    }

    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    public boolean canStoreResult() {
        return true;
    }

    protected void runJobs(AnalyzerResult result) {
        JavaVisibilityMetricsJob job = new JavaVisibilityMetricsJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class JavaVisibilityMetricsJob
    extends AnalyzerJob {
        private JavaVisibilityMetricsJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
        }

        protected void internalRun() {
            VisibilityVisitor v = new VisibilityVisitor();
            ((LogicalModuleNamespaces)this.getSoftwareSystem().getUniqueExistingChild(LogicalModuleNamespaces.class)).accept((NamedElement.INamedElementVisitor)v);
        }

        private class VisibilityVisitor
        extends NamedElementVisitor
        implements LogicalModuleNamespace.IVisitor,
        LogicalModuleProgrammingElement.IVisitor,
        PhysicalElementBasedExternalLogicalRoot.IVisitor,
        ModuleBasedLogicalNamespaceRoot.IVisitor,
        ExternalLogicalNamespaceRoot.IVisitor {
            private int m_publicClasses = 0;
            private int m_totalClasses = 0;
            private double m_visibilityTotal = 0.0;
            private int m_visibilityCounter = 0;
            private int m_avgPackageVisibilityCounter = 0;
            private double m_avgPackageVisibilityTotal = 0.0;
            private final Deque<Integer> m_publicClassesStack = new ArrayDeque<Integer>();
            private final Deque<Integer> m_totalClassesStack = new ArrayDeque<Integer>();
            private final Deque<Double> m_visibilityTotalStack = new ArrayDeque<Double>();
            private final Deque<Integer> m_visibilityCounterStack = new ArrayDeque<Integer>();

            private VisibilityVisitor() {
            }

            public void visitModuleBasedLogicalNamespaceRoot(ModuleBasedLogicalNamespaceRoot element) {
                assert (element != null) : "Parameter 'element' of method 'visitModuleBasedLogicalNamespaceRoot' must not be null";
                if (element.getLanguage() == JavaLanguage.INSTANCE) {
                    this.visitChildrenOf((NamedElement)element);
                    if (this.m_avgPackageVisibilityCounter > 0) {
                        JavaVisibilityMetricsAnalyzerAdapter.this.storeMetricValue(JavaVisibilityMetricsJob.this.getResult(), (NamedElement)element.getPhysicalElement(), this.m_avgPackageVisibilityTotal / (double)this.m_avgPackageVisibilityCounter, ((JavaVisibilityMetricsJob)JavaVisibilityMetricsJob.this).JavaVisibilityMetricsAnalyzerAdapter.this.m_averagePackagePublicVisibility);
                    }
                    this.m_avgPackageVisibilityCounter = 0;
                    this.m_avgPackageVisibilityTotal = 0.0;
                }
            }

            public void visitLogicalModuleNamespace(LogicalModuleNamespace element) {
                this.m_publicClassesStack.push(this.m_publicClasses);
                this.m_totalClassesStack.push(this.m_totalClasses);
                this.m_visibilityCounterStack.push(this.m_visibilityCounter);
                this.m_visibilityTotalStack.push(this.m_visibilityTotal);
                this.m_visibilityCounter = 0;
                this.m_publicClasses = 0;
                this.m_totalClasses = 0;
                this.m_visibilityTotal = 0.0;
                this.visitChildrenOf((NamedElement)element);
                if (this.m_totalClasses > 0) {
                    double visibility = 100.0 * (double)this.m_publicClasses / (double)this.m_totalClasses;
                    JavaVisibilityMetricsAnalyzerAdapter.this.storeMetricValue(JavaVisibilityMetricsJob.this.getResult(), (NamedElement)element, visibility, ((JavaVisibilityMetricsJob)JavaVisibilityMetricsJob.this).JavaVisibilityMetricsAnalyzerAdapter.this.m_packagePublicVisibility);
                    ++this.m_avgPackageVisibilityCounter;
                    this.m_avgPackageVisibilityTotal += visibility;
                }
                if (this.m_visibilityCounter > 0) {
                    JavaVisibilityMetricsAnalyzerAdapter.this.storeMetricValue(JavaVisibilityMetricsJob.this.getResult(), (NamedElement)element, this.m_visibilityTotal / (double)this.m_visibilityCounter, ((JavaVisibilityMetricsJob)JavaVisibilityMetricsJob.this).JavaVisibilityMetricsAnalyzerAdapter.this.m_averageClassPublicVisibility);
                }
                this.m_publicClasses = this.m_publicClassesStack.pop();
                this.m_totalClasses = this.m_totalClassesStack.pop();
                this.m_visibilityCounter = this.m_visibilityCounterStack.pop();
                this.m_visibilityTotal = this.m_visibilityTotalStack.pop();
            }

            public void visitLogicalModuleProgrammingElement(LogicalModuleProgrammingElement element) {
                if (element.ignoreIssues()) {
                    return;
                }
                ProgrammingElement primary = element.getPrimaryProgrammingElement();
                if (!(primary instanceof JavaType)) {
                    return;
                }
                JavaType type = (JavaType)primary;
                if (!type.isInterface()) {
                    int total = 0;
                    int publicMembers = 0;
                    for (JavaElement member : type.getChildren(JavaElement.class)) {
                        ++total;
                        if (member.isPrivate()) continue;
                        ++publicMembers;
                    }
                    double visibility = total == 0 ? 0.0 : 100.0 * (double)publicMembers / (double)total;
                    JavaVisibilityMetricsAnalyzerAdapter.this.storeMetricValue(JavaVisibilityMetricsJob.this.getResult(), (NamedElement)type, visibility, ((JavaVisibilityMetricsJob)JavaVisibilityMetricsJob.this).JavaVisibilityMetricsAnalyzerAdapter.this.m_classPublicVisibility);
                    ++this.m_visibilityCounter;
                    this.m_visibilityTotal += visibility;
                }
                if (type.isPublic()) {
                    ++this.m_publicClasses;
                }
                ++this.m_totalClasses;
            }

            public void visitPhysicalElementBasedExternalLogicalRoot(PhysicalElementBasedExternalLogicalRoot element) {
            }

            public void visitExternalLogicalNamespaceRoot(ExternalLogicalNamespaceRoot element) {
            }
        }
    }
}

