/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptionUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import de.schlichtherle.truezip.file.TFile;

public final class SysInclude
extends Path
implements ICompilerOption {
    public static final String PREFIX = "--sys_include";

    private SysInclude(NamedElement parent, TFile file) {
        super(parent, file);
    }

    @Override
    public String getValue() {
        return "--sys_include=" + this.getFile().getNormalizedAbsolutePath();
    }

    public String getFullyQualifiedNamePart() {
        return CompilerOptionUtility.createFullyQualifiedNamePart(this.getClass(), this.getValue());
    }

    public String toString() {
        return this.getValue();
    }

    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
    }

    public static SysInclude create(NamedElement parent, String line) {
        assert (parent != null) : "Parameter 'parent' of method 'Builder' must not be null";
        assert (line != null && line.length() > 0) : "Parameter 'line' of method 'Builder' must not be empty";
        TFile file = null;
        String[] split = line.split("=");
        if (split.length > 1) {
            file = new TFile(split[1].trim());
        }
        if (file == null) {
            return null;
        }
        return new SysInclude(parent, file);
    }

    public static String getPathFromOptionLine(String line) {
        String[] split = line.split("=");
        if (split.length > 1) {
            return split[1].trim();
        }
        return null;
    }

    @Override
    public Result validate() {
        this.resetFile();
        Result result = new Result();
        if (!this.getFile().exists()) {
            result.addErrorMessage("Path '" + this.getFile().getNormalizedAbsolutePath() + "' does not exist!");
        }
        return result;
    }
}

