/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusStructureItem;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CppAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.ICppHasAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppHasSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.IHasFqnSerialNumber;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureParser;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.OldSignatureHelper;
import java.io.IOException;

public final class CppField
extends ProgrammingElement
implements ICppHasAccessSpecifier,
ICppNamespaceMember,
IField,
ICppHasSignature,
IHasFqnSerialNumber {
    private String m_signature = CppSignature.UNDEFINED;
    private CppAccessSpecifier m_accessSpecifier;
    private short m_serialNumberForQualifiedName = 0;

    public CppField(NamedElement parent) {
        super(parent);
    }

    public CppField(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber) {
        super(msp, parent, name, lineNumber);
    }

    public boolean isMember() {
        return true;
    }

    public String getImageResourceName() {
        switch (this.getAccessSpecifier()) {
            case PRIVATE: {
                return "CppFieldPrivate";
            }
            case PROTECTED: {
                return "CppFieldProtected";
            }
            case PUBLIC: {
                return "CppFieldPublic";
            }
        }
        assert (false) : "Unhandled constant in method 'getImageResourceName'" + String.valueOf((Object)this.getAccessSpecifier());
        return "";
    }

    @Override
    public String getSignature() {
        return this.m_signature;
    }

    @Override
    public void setSignature(String signature) {
        this.m_signature = signature;
    }

    @Override
    @Property
    public CppAccessSpecifier getAccessSpecifier() {
        return this.m_accessSpecifier;
    }

    public void setAccessSpecifier(CppAccessSpecifier accessSpecifier) {
        this.m_accessSpecifier = accessSpecifier;
    }

    @Override
    public void setSerialNumberForQualifiedName(short serialNumberFoQualifiedName) {
        this.m_serialNumberForQualifiedName = serialNumberFoQualifiedName;
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        String result = "f" + INNER_NAME_PARTS_SEPARATOR + super.getFullyQualifiedNamePart();
        if (this.m_serialNumberForQualifiedName > 0) {
            result = result + INNER_NAME_PARTS_SEPARATOR + Short.toString(this.m_serialNumberForQualifiedName);
        }
        return result;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() <= 16) {
            CppSignature sig = new CppSignature(reader);
            this.m_signature = OldSignatureHelper.convert(sig, CppSignatureParser.UNDEFINED);
        } else {
            this.m_signature = reader.readString();
        }
        this.m_accessSpecifier = CppAccessSpecifier.values()[reader.readByte()];
        if (reader.getVersion() >= 21) {
            this.m_serialNumberForQualifiedName = reader.readShort();
        }
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_signature);
        writer.writeByte((byte)this.m_accessSpecifier.ordinal());
        writer.writeShort(this.m_serialNumberForQualifiedName);
    }

    public IStructureItem getStructureItem() {
        return CPlusPlusStructureItem.PROGRAMMING_ELEMENT;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppField(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public ProgrammingElement getProgrammingElement() {
        return this;
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppField(CppField var1);
    }
}

