/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.ILogicalProgrammingElementOwner;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionNamespace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppProgrammingElement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CPlusPlusLogicalTypeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusLogicalTypeHelper.class);

    private CPlusPlusLogicalTypeHelper() {
    }

    static void createDirectChildren(List<ProgrammingElement> programmingElements, ILogicalProgrammingElementOwner owner) {
        Object nextFqNamePart;
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'createDirectChildren' must not be empty";
        assert (owner != null) : "Parameter 'owner' of method 'createDirectChildren' must not be null";
        MultipleValueMap classStructUnionToClassStructUnionNamespaces = new MultipleValueMap();
        MultipleValueMap nameToRoutines = new MultipleValueMap();
        MultipleValueMap nameToClassStructUnions = new MultipleValueMap();
        MultipleValueMap nameToOthers = new MultipleValueMap();
        for (ProgrammingElement next : programmingElements) {
            if (next instanceof CppClassStructUnionNamespace) {
                CppClassStructUnion nextReferencedType = ((CppClassStructUnionNamespace)next).getReferencedType();
                classStructUnionToClassStructUnionNamespaces.put((Object)nextReferencedType, (Object)((CppClassStructUnionNamespace)next));
                continue;
            }
            Object namePrefix = "";
            if (next instanceof ICppProgrammingElement) {
                if (((ICppProgrammingElement)next).residesInAnonymousNamespace()) {
                    CppSource sourceFile = (CppSource)((Object)next.getParent(CppSource.class, ParentMode.FIRST_PARENT));
                    if (sourceFile != null) {
                        namePrefix = ((Object)((Object)sourceFile)).hashCode() + IElement.INNER_NAME_PARTS_SEPARATOR;
                    } else {
                        LOGGER.error("Element saying it 'residesInAnonymousNamespace' has no 'CppSource' parent: " + String.valueOf(next));
                    }
                }
            } else {
                LOGGER.error("Not an 'ICppProgrammingElement': " + String.valueOf(next));
            }
            if (next instanceof IRoutine) {
                nameToRoutines.put((Object)((String)namePrefix + next.getPresentationName(true)), (Object)next);
                continue;
            }
            if (next instanceof CppClassStructUnion) {
                nameToClassStructUnions.put((Object)((String)namePrefix + next.getRawPresentationName(true)), (Object)((CppClassStructUnion)next));
                continue;
            }
            nameToOthers.put((Object)((String)namePrefix + next.getPresentationName(true)), (Object)next);
        }
        int emptyRoutineNames = 0;
        for (String nextName : nameToRoutines.keySet()) {
            List nextProgrammingElements = nameToRoutines.get((Object)nextName);
            assert (nextProgrammingElements != null && !nextProgrammingElements.isEmpty()) : "'nextProgrammingElements' of method 'createDirectChildren' must not be empty";
            String nextFqBaseNamePart = nextName;
            if (nextFqBaseNamePart == null || nextFqBaseNamePart.isEmpty()) {
                LOGGER.error("The routine name is empty: " + ((ProgrammingElement)nextProgrammingElements.get(0)).getDebugInfo());
                nextFqBaseNamePart = Integer.toString(++emptyRoutineNames);
            }
            String nextFqNamePart2 = nextFqBaseNamePart + IElement.INNER_NAME_PARTS_SEPARATOR + "Routine";
            owner.addLogicalProgrammingElement(nextProgrammingElements, nextFqNamePart2);
        }
        int emptyClassStructUnionName = 0;
        for (String nextName : nameToClassStructUnions.keySet()) {
            List nextClassStructUnions = nameToClassStructUnions.get((Object)nextName);
            assert (nextClassStructUnions != null && !nextClassStructUnions.isEmpty()) : "'nextClassStructUnions' of method 'createDirectChildren' must not be empty";
            String nextFqBaseNamePart = nextName;
            if (nextFqBaseNamePart == null || nextFqBaseNamePart.isEmpty()) {
                LOGGER.error("The class,struct,union name is empty: " + ((CppClassStructUnion)nextClassStructUnions.get(0)).getDebugInfo());
                nextFqBaseNamePart = Integer.toString(++emptyClassStructUnionName);
            }
            nextFqNamePart = nextFqBaseNamePart + IElement.INNER_NAME_PARTS_SEPARATOR + "ClassStructUnion";
            ArrayList nextProgrammingElements = new ArrayList(nextClassStructUnions);
            for (CppClassStructUnion nextClassStructUnion : nextClassStructUnions) {
                List nextClassStructUnionNamespaces = classStructUnionToClassStructUnionNamespaces.get((Object)nextClassStructUnion);
                if (nextClassStructUnionNamespaces.isEmpty()) continue;
                nextProgrammingElements.addAll(nextClassStructUnionNamespaces);
            }
            owner.addLogicalProgrammingElement(nextProgrammingElements, (String)nextFqNamePart);
        }
        int emptyOtherNames = 0;
        for (String nextName : nameToOthers.keySet()) {
            List nextProgrammingElements = nameToOthers.get((Object)nextName);
            assert (nextProgrammingElements != null && !nextProgrammingElements.isEmpty()) : "'nextProgrammingElements' of method 'createDirectChildren' must not be empty";
            nextFqNamePart = nextName;
            if (nextFqNamePart == null || ((String)nextFqNamePart).isEmpty()) {
                LOGGER.error("The other name is empty: " + ((ProgrammingElement)nextProgrammingElements.get(0)).getDebugInfo());
                nextFqNamePart = Integer.toString(++emptyOtherNames);
            }
            owner.addLogicalProgrammingElement(nextProgrammingElements, (String)nextFqNamePart);
        }
    }

    public static ProgrammingElement getPrimaryProgrammingElement(List<? extends ProgrammingElement> programmingElements) {
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'getPrimaryProgrammingElement' must not be empty";
        for (ProgrammingElement programmingElement : programmingElements) {
            if (programmingElement instanceof ICppProgrammingElement) {
                if (!((ICppProgrammingElement)programmingElement).isDefinition()) continue;
                return programmingElement;
            }
            LOGGER.error("Not an 'ICppProgrammingElement': " + String.valueOf(programmingElement));
        }
        return programmingElements.get(0);
    }
}

