/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.DiagnosticMode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.IParserResultHandler;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParserDaemon;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingRequest;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusParserConfigurationProvider;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingService
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsingService.class);
    private final LinkedBlockingQueue<ParsingRequest> m_requestQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<ParsingResult> m_resultQueue = new LinkedBlockingQueue();
    private final List<String> m_daemonErrors = new ArrayList<String>();
    private final TFile m_diagnosticDir;
    private final TFile m_hiddenDataDirectory;
    private final DiagnosticMode m_mode;
    private final InstCompilerDefinition m_definition;
    private final int m_numberOfDaemons;
    private final int m_stackSize;
    private final IAddedOrChangedSourceFileProcessor m_fileListener;
    private final OperationResult m_result;
    private final List<ParserDaemon> m_daemons = new ArrayList<ParserDaemon>();
    private int m_requestCounter = 0;

    public ParsingService(SoftwareSystem system, TFile diagnosticDir, DiagnosticMode mode, ICPlusPlusParserConfigurationProvider configProvider, IAddedOrChangedSourceFileProcessor fileListener, OperationResult result) {
        assert (system != null) : "Parameter 'system' of method 'ParsingService' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'ParsingService' must not be null";
        assert (diagnosticDir != null) : "Parameter 'diagnosticDir' of method 'ParsingService' must not be null";
        assert (fileListener != null) : "Parameter 'fileListener' of method 'ParsingService' must not be null";
        assert (configProvider != null) : "Parameter 'configProvider' of method 'ParsingService' must not be null";
        assert (result != null);
        this.m_diagnosticDir = diagnosticDir;
        this.m_mode = mode;
        this.m_numberOfDaemons = configProvider.getNumberOfDaemons();
        this.m_stackSize = configProvider.getDaemonStackSize();
        this.m_fileListener = fileListener;
        this.m_result = result;
        Installation installation = ((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation();
        assert (installation != null) : "'installation' of method 'aboutToParse' must not be null";
        this.m_definition = ((ICPlusPlusInstallationExtension)installation.getExtension(ICPlusPlusInstallationExtension.class)).getActiveCompilerDefinition();
        assert (this.m_definition != null) : "'definition' of method 'aboutToParse' must not be null";
        this.m_hiddenDataDirectory = ((Files)system.getUniqueExistingChild(Files.class)).getHiddenDataDirectory();
        this.m_daemons.add(new ParserDaemon(1, this.m_requestQueue, this.m_resultQueue, this, this.m_definition, this.m_mode, this.m_hiddenDataDirectory, this.m_diagnosticDir, this.m_fileListener, this.m_stackSize));
    }

    public InstCompilerDefinition getDefinition() {
        return this.m_definition;
    }

    public void addParsingRequest(ParsingRequest req) {
        assert (req != null) : "Parameter 'req' of method 'addParsingRequest' must not be null";
        try {
            if (req.isValid()) {
                this.m_requestQueue.put(req);
                ++this.m_requestCounter;
            } else {
                this.m_resultQueue.put(new ParsingResult(req.getModule(), req.getSourceFile(), -1, null, null));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean processRequests(IWorkerContext workerContext, IParserResultHandler handler) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processRequests' must not be null";
        assert (handler != null) : "Parameter 'handler' of method 'processRequests' must not be null";
        int numberOfDaemons = Math.min(this.m_numberOfDaemons, this.m_requestCounter);
        int parsedSuccessfully = 0;
        int parsed = 0;
        LOGGER.info("Using {} parser daemons", (Object)numberOfDaemons);
        int i = 2;
        while (i <= numberOfDaemons) {
            this.m_daemons.add(new ParserDaemon(i, this.m_requestQueue, this.m_resultQueue, this, this.m_definition, this.m_mode, this.m_hiddenDataDirectory, this.m_diagnosticDir, this.m_fileListener, this.m_stackSize));
            ++i;
        }
        try {
            ParsingResult result;
            workerContext.beginBlockOfWork(this.m_requestCounter);
            while (this.m_requestCounter > 0 && (result = this.m_resultQueue.poll(60L, TimeUnit.SECONDS)) != null) {
                block16: {
                    if (result.isCancelled()) {
                        this.m_resultQueue.clear();
                        break;
                    }
                    ++parsed;
                    try {
                        try {
                            workerContext.working("Parsed " + result.getSourceFile().getFile().getName() + " from module " + result.getModule().getShortName(), true);
                            if (result.requestFailed()) {
                                handler.failedToParse(result);
                            } else {
                                handler.processParserResult(result);
                                ++parsedSuccessfully;
                            }
                        }
                        catch (Throwable ex) {
                            LOGGER.error("Excepion while processing file: " + result.getSourceFile().getName(), ex);
                            handler.internalError(result, ex);
                            workerContext.workItemCompleted();
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        workerContext.workItemCompleted();
                        throw throwable;
                    }
                    workerContext.workItemCompleted();
                }
                --this.m_requestCounter;
                if (!workerContext.hasBeenCanceled() || this.m_requestCounter <= 0) continue;
                this.m_requestQueue.clear();
                this.m_resultQueue.add(new ParsingResult());
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected exception in parsing service: ", (Throwable)e);
        }
        this.m_daemons.forEach(d -> d.join());
        LOGGER.info("Parser loop exited. parsed={}, success={}, left={}", new Object[]{parsed, parsedSuccessfully, this.m_requestCounter});
        for (String msg : this.m_daemonErrors) {
            this.m_result.addWarning((OperationResult.IMessageCause)CppCauses.PARSING_DEAMON_FAILED, msg, new Object[0]);
        }
        return parsed == 0 || parsedSuccessfully > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        List<String> list = this.m_daemonErrors;
        synchronized (list) {
            this.m_daemonErrors.add(e.getMessage());
        }
    }
}

