/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.controller.system.MSBuildException;
import com.hello2morrow.sonargraph.core.controller.system.MSBuildExecutor;
import com.hello2morrow.sonargraph.foundation.commandline.ProcessExecutor;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsImportModuleDto;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusMSBuildExecutor
extends MSBuildExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusMSBuildExecutor.class);
    private static final String MODULE_INCLUDES_PREFIX = "Module include directories: ";
    private static final String COMPILE_FILES_PREFIX = "Compile files: ";
    private static final String EXCLUDED_FILES_PREFIX = "Excluded files: ";
    private static final String MACROS_PREFIX = "Macros: ";
    private static final String INCLUDE_DIRS_PREFIX = "Include directories: ";
    private static final String USING_DIR_PREFIX = "Using directories: ";
    private static final String RUNTIME_PREFIX = "Runtime: ";
    private static final String MANAGED_PREFIX = "Managed: ";
    private static final String FORCED_INCLUDES_PREFIX = "Forced includes: ";
    private final TFile m_vcvarall_bat;
    private final String m_architecture;
    private final String m_toolsVersion;

    public CPlusPlusMSBuildExecutor(TFile vcvarsall_bat, String architecture, TFile projectFile, String toolsVersion, TFile solutionDir) {
        super(projectFile, null, solutionDir);
        assert (vcvarsall_bat != null) : "Parameter 'vcvarsall_bat' must not be null";
        assert (vcvarsall_bat.exists()) : "Parameter 'vcvarsall_bat' must be an existing file";
        assert (architecture != null && architecture.length() > 0) : "Parameter 'architecture' must not be empty";
        assert (toolsVersion != null && toolsVersion.length() > 0) : "Parameter 'toolsVersion' must not be empty";
        this.m_vcvarall_bat = vcvarsall_bat;
        this.m_architecture = architecture;
        this.m_toolsVersion = toolsVersion;
    }

    private void addIfNotPresent(List<String> list, String value) {
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    protected Map<String, String> getProperties() {
        Map props = super.getProperties();
        props.put("toolsVersion", this.m_toolsVersion);
        return props;
    }

    protected String getTemplateName() {
        return "cppMsBuild.template";
    }

    protected String getWrapperFileName() {
        return "h2m" + CPlusPlusFileType.VISUAL_STUDIO_PROJECT_FILE.getDefaultExtension();
    }

    public CPlusPlusVsImportModuleDto runMsBuild(String configuration, String platform) throws MSBuildException {
        TFile wrapper;
        OperationResult result = new OperationResult("Run MsBuild");
        try {
            wrapper = this.writeProjectWrapper();
        }
        catch (Exception ex) {
            result.addError((OperationResult.IMessageCause)CppCauses.INTERNAL_ERROR, ex.getMessage(), new Object[0]);
            return null;
        }
        try {
            ArrayList<Object> command = new ArrayList<Object>();
            command.add(this.m_vcvarall_bat.getNormalizedAbsolutePath());
            command.add(this.m_architecture);
            command.add("&&");
            command.add("msbuild");
            command.add("/nologo");
            command.add("/t:h2moptions");
            command.add("/p:Configuration=" + configuration);
            command.add("/p:Platform=" + platform);
            if (this.getSolutionDir() != null) {
                String path = this.getSolutionDir().getNormalizedAbsolutePath();
                command.add("/p:SolutionDir=" + path + FileUtility.SYSTEM_PATH_SEPARATOR);
            }
            command.add(wrapper.getNormalizedAbsolutePath());
            LOGGER.info("Executing: {}", command);
            String content = ProcessExecutor.execute(command, null, (OperationResult)result, (OperationResult.IMessageCause)CppCauses.MSBUILD_EXCEPTION);
            if (result.containsError() || result.getWarningCauses().contains(ProcessExecutor.ProcessMessageCause.EXIT_VALUE_NOT_ZERO)) {
                String msg = "Problem executing msbuild: " + result.toString();
                LOGGER.error(msg);
                throw new MSBuildException(msg);
            }
            CPlusPlusVsImportModuleDto cPlusPlusVsImportModuleDto = this.processMsBuildOutput(content, configuration, platform);
            return cPlusPlusVsImportModuleDto;
        }
        catch (AssertionError err) {
            result.addError((OperationResult.IMessageCause)CppCauses.INTERNAL_ERROR);
            return null;
        }
        finally {
            if (result.containsError()) {
                try {
                    List content = FileUtility.getFileLinesWithoutLineBreaks((TFile)this.getProjectFile());
                    LOGGER.error("Wrapped project file content: \n{}", (Object)StringUtility.concat((Collection)content, (String)StringUtility.LINE_SEPARATOR));
                }
                catch (IOException ioe) {
                    LOGGER.error("Failed to get content of project file '{}': {}", (Object)this.getProjectFile().getAbsolutePath(), (Object)ioe.getMessage());
                }
            }
            try {
                wrapper.rm();
            }
            catch (IOException ioe) {
                LOGGER.error("Failed to delete file '{}': {}", (Object)wrapper.getAbsolutePath(), (Object)ioe.getMessage());
            }
        }
    }

    /*
     * Exception decompiling
     */
    private CPlusPlusVsImportModuleDto processMsBuildOutput(String output, String configuration, String platform) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[11] lbl252 : CaseStatement: default:\u000a, @NONE, blocks:[11] lbl252 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<TFile> processModuleIncludes(String[] moduleIncludesList) {
        ArrayList<TFile> moduleIncludeDirectories = new ArrayList<TFile>();
        String[] stringArray = moduleIncludesList;
        int n = moduleIncludesList.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            String trimmed = FileUtility.convertPathToUniversalForm((String)next.trim());
            if (!trimmed.isEmpty()) {
                if ((trimmed.contains("/Microsoft Visual Studio ") || trimmed.contains("/Microsoft Visual Studio/")) && trimmed.contains("/VC/") || trimmed.contains("/Windows Kits/")) {
                    LOGGER.debug("Omitting include directory {}", (Object)trimmed);
                } else {
                    TFile path = new TFile(trimmed);
                    if (path.exists() && path.isDirectory()) {
                        moduleIncludeDirectories.add(path);
                    } else {
                        LOGGER.info("Omitting not existing include directory {}", (Object)trimmed);
                    }
                }
            }
            ++n2;
        }
        return moduleIncludeDirectories;
    }

    private String removeTrailingSeparator(String input, String separator) {
        assert (input != null && input.length() > 0) : "Input must not be empty";
        assert (separator != null && separator.length() > 0) : "Separator must not be empty";
        if (input.endsWith(separator)) {
            return input.substring(0, input.lastIndexOf(separator));
        }
        return input;
    }
}

