/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Component;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.HeaderNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Link;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Node;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;

final class SourceNode
extends Node {
    private final CppSourceFile m_source;
    private final IDirectoryPath m_dir;

    SourceNode(CppSourceFile source) {
        assert (source != null) : "Parameter 'source' of method 'SourceNode' must not be null";
        assert (source.isValid()) : " Source " + source.getAbsolutePath() + " is not valid";
        this.m_dir = (IDirectoryPath)source.getParent(IDirectoryPath.class, new Class[0]);
        assert (this.m_dir != null) : "Source " + source.getAbsolutePath() + " has no proper directory parent.";
        this.m_source = source;
    }

    IDirectoryPath getDirectory() {
        return this.m_dir;
    }

    @Override
    protected void buildComponent(Component component) {
        component.addSource(this);
        Module myModule = this.getModule();
        for (Link link : this.getIncoming()) {
            HeaderNode source = link.getFrom();
            if (((Node)source).getModule() != myModule && ((Node)source).getModule() != null || component.contains(source) || source.getComponent() != null) continue;
            ((Node)source).buildComponent(component);
        }
    }

    @Override
    CppSourceFile getSource() {
        return this.m_source;
    }

    @Override
    Module getModule() {
        return (Module)this.m_source.getParent(Module.class, new Class[0]);
    }

    public String toString() {
        return this.m_source.getName();
    }
}

